/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IStepOverHandler;

@Immutable
public class DsfStepOverCommand
implements IStepOverHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final DsfSteppingModeTarget fSteppingMode;

    public DsfStepOverCommand(DsfSession session, DsfSteppingModeTarget steppingMode) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
        this.fSteppingMode = steppingMode;
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){
            final IRunControl.StepType stepType;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.stepType = DsfStepOverCommand.this.getStepType();
            }

            @Override
            public void doExecute() {
                SteppingController steppingControl = this.getSteppingController();
                if (steppingControl == null) {
                    request.setEnabled(false);
                    request.done();
                    return;
                }
                steppingControl.canEnqueueStep(this.getContext(), this.stepType, new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

                    protected void handleCompleted() {
                        request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                        request.done();
                    }
                });
            }
        }));
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        final IRunControl.StepType stepType = this.getStepType();
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            @Override
            public void doExecute() {
                this.getSteppingController().enqueueStep(this.getContext(), stepType);
            }
        }));
        return true;
    }

    protected final IRunControl.StepType getStepType() {
        boolean instructionSteppingEnabled = this.fSteppingMode != null && this.fSteppingMode.isInstructionSteppingEnabled();
        return instructionSteppingEnabled ? IRunControl.StepType.INSTRUCTION_STEP_OVER : IRunControl.StepType.STEP_OVER;
    }
}

