/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorBase;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.LimitedInputStream;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class StoreAccessor
extends StoreAccessorBase {
    protected StoreAccessor(Store store, ISession session) {
        super(store, session);
    }

    protected StoreAccessor(Store store, ITransaction transaction) {
        super(store, transaction);
    }

    @Override
    protected void doWrite(InternalCommitContext context, OMMonitor monitor) {
        block20: {
            CDOBranch branch = context.getBranchPoint().getBranch();
            long timeStamp = context.getBranchPoint().getTimeStamp();
            long previousTimeStamp = context.getPreviousTimeStamp();
            String userID = context.getUserID();
            String commitComment = context.getCommitComment();
            CDOBranchPoint mergeSource = context.getCommitMergeSource();
            Store store = this.getStore();
            boolean deltas = store.getSupportedChangeFormats().contains((Object)IStore.ChangeFormat.DELTA);
            InternalCDOPackageUnit[] newPackageUnits = context.getNewPackageUnits();
            InternalCDORevision[] newObjects = context.getNewObjects();
            CDOID[] detachedObjects = context.getDetachedObjects();
            InternalCDORevisionDelta[] dirtyObjectDeltas = context.getDirtyObjectDeltas();
            InternalCDORevision[] dirtyObjects = context.getDirtyObjects();
            int dirtyCount = deltas ? dirtyObjectDeltas.length : dirtyObjects.length;
            int postProcessCount = this.needsRevisionPostProcessing() ? newObjects.length + detachedObjects.length + dirtyCount : 0;
            try {
                ExtendedDataInputStream in;
                monitor.begin((double)(4 + newPackageUnits.length + newObjects.length + detachedObjects.length + dirtyCount + postProcessCount));
                this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, commitComment, mergeSource, monitor.fork());
                this.writePackageUnits(newPackageUnits, monitor.fork((double)newPackageUnits.length));
                CDOCommonRepository.IDGenerationLocation idGenerationLocation = store.getRepository().getIDGenerationLocation();
                if (idGenerationLocation == CDOCommonRepository.IDGenerationLocation.STORE) {
                    this.addIDMappings(context, monitor.fork());
                }
                this.applyIDMappings(context, monitor);
                if (context.getOriginalCommmitData() != null) {
                    newObjects = context.getNewObjects();
                    detachedObjects = context.getDetachedObjects();
                    dirtyObjectDeltas = context.getDirtyObjectDeltas();
                    dirtyObjects = context.getDirtyObjects();
                    dirtyCount = deltas ? dirtyObjectDeltas.length : dirtyObjects.length;
                    int n = postProcessCount = this.needsRevisionPostProcessing() ? newObjects.length + detachedObjects.length + dirtyCount : 0;
                }
                if (detachedObjects.length != 0) {
                    this.detachObjects(detachedObjects, branch, timeStamp, monitor.fork((double)detachedObjects.length));
                }
                if (newObjects.length != 0) {
                    this.writeNewObjectRevisions(context, newObjects, branch, monitor.fork((double)newObjects.length));
                }
                if (dirtyCount != 0) {
                    if (deltas) {
                        this.writeRevisionDeltas(dirtyObjectDeltas, branch, timeStamp, monitor.fork((double)dirtyCount));
                    } else {
                        this.writeDirtyObjectRevisions(context, dirtyObjects, branch, monitor.fork((double)dirtyCount));
                    }
                }
                if (this.needsRevisionPostProcessing()) {
                    this.postProcessRevisions(context, monitor.fork((double)postProcessCount));
                }
                if ((in = context.getLobs()) != null) {
                    OMMonitor.Async async = monitor.forkAsync();
                    try {
                        try {
                            int count = in.readInt();
                            int i = 0;
                            while (i < count) {
                                byte[] id = in.readByteArray();
                                long size = in.readLong();
                                if (size > 0L) {
                                    this.writeBlob(id, size, (InputStream)new LimitedInputStream((InputStream)in, size));
                                } else {
                                    this.writeClob(id, -size, new InputStreamReader((InputStream)new LimitedInputStream((InputStream)in, -size)));
                                }
                                ++i;
                            }
                            break block20;
                        }
                        catch (IOException ex) {
                            throw WrappedException.wrap((Exception)ex);
                        }
                    }
                    finally {
                        async.stop();
                    }
                }
                monitor.worked();
            }
            finally {
                monitor.done();
            }
        }
    }

    protected boolean needsRevisionPostProcessing() {
        return false;
    }

    protected void postProcessRevisions(InternalCommitContext context, OMMonitor monitor) {
    }

    protected void applyIDMappings(InternalCommitContext context, OMMonitor monitor) {
        context.applyIDMappings(monitor.fork());
    }

    @Deprecated
    protected abstract void writeCommitInfo(CDOBranch var1, long var2, long var4, String var6, String var7, OMMonitor var8);

    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, OMMonitor monitor) {
        this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, monitor);
    }

    protected void writeNewObjectRevisions(InternalCommitContext context, InternalCDORevision[] newObjects, CDOBranch branch, OMMonitor monitor) {
        this.writeRevisions(newObjects, branch, monitor);
    }

    protected void writeDirtyObjectRevisions(InternalCommitContext context, InternalCDORevision[] dirtyObjects, CDOBranch branch, OMMonitor monitor) {
        this.writeRevisions(dirtyObjects, branch, monitor);
    }

    protected abstract void writeRevisions(InternalCDORevision[] var1, CDOBranch var2, OMMonitor var3);

    protected abstract void writeRevisionDeltas(InternalCDORevisionDelta[] var1, CDOBranch var2, long var3, OMMonitor var5);

    protected abstract void detachObjects(CDOID[] var1, CDOBranch var2, long var3, OMMonitor var5);

    protected abstract void writeBlob(byte[] var1, long var2, InputStream var4) throws IOException;

    protected abstract void writeClob(byte[] var1, long var2, Reader var4) throws IOException;
}

