/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;

public class URIStorage
implements IStorage {
    private final URI uri;
    private final URIHandler handler;
    private URIConverter converter;

    public URIStorage(URI uri, URIHandler handler, URIConverter converter) {
        this.uri = uri;
        this.handler = handler;
        this.converter = converter;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public InputStream getContents() throws CoreException {
        Map<String, URIConverter> options = Collections.singletonMap("URI_CONVERTER", this.converter);
        try {
            return this.handler.createInputStream(this.converter.normalize(this.uri), options);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.compare.ide", e.getMessage(), (Throwable)e));
        }
    }

    public IPath getFullPath() {
        URI normalized = this.converter.normalize(this.uri);
        String path = normalized.isRelative() ? normalized.toString() : (normalized.isPlatformResource() ? normalized.toPlatformString(true) : normalized.toString());
        return new Path(path);
    }

    public String getName() {
        return URI.decode((String)this.converter.normalize(this.uri).lastSegment());
    }

    public boolean isReadOnly() {
        Map<String, Set<String>> options = Collections.singletonMap("requestedAttributes", Collections.singleton("readOnly"));
        Map attributes = this.handler.getAttributes(this.converter.normalize(this.uri), options);
        return Boolean.TRUE.equals(attributes.get("readOnly"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.converter == null ? 0 : this.converter.hashCode());
        result = 31 * result + (this.handler == null ? 0 : this.handler.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URIStorage other = (URIStorage)obj;
        if (this.converter == null ? other.converter != null : !this.converter.equals(other.converter)) {
            return false;
        }
        if (this.handler == null ? other.handler != null : !this.handler.equals(other.handler)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public URI getURI() {
        return this.uri;
    }
}

