/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class CreateInheritedEntityFeature
extends AbstractCreateConnectionFeature {
    public CreateInheritedEntityFeature(IFeatureProvider fp) {
        this(fp, JPAEditorMessages.CreateIsARelationFeature_name, JPAEditorMessages.CreateIsARelationFeature_description);
    }

    public CreateInheritedEntityFeature(IFeatureProvider fp, String name, String description) {
        super(fp, name, description);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        PersistentType superclass = this.getPersistentType(context.getSourceAnchor());
        if (superclass == null) {
            return false;
        }
        if (context.getTargetAnchor() == null) {
            return true;
        }
        return context.getTargetAnchor().getParent() instanceof Diagram;
    }

    public Connection create(ICreateConnectionContext context) {
        PersistentType mappedSuperclass = this.getPersistentType(context.getSourceAnchor());
        CreateJPAEntityFeature createEntityFeature = null;
        try {
            createEntityFeature = new CreateJPAEntityFeature(this.getFeatureProvider(), mappedSuperclass);
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot create a new JPA entity class", e);
            return null;
        }
        CreateContext ctx = new CreateContext();
        Object[] res = createEntityFeature.create((ICreateContext)ctx);
        PersistentType newEntity = (PersistentType)res[0];
        AddJPAEntityFeature ft = new AddJPAEntityFeature(this.getFeatureProvider(), true);
        AddContext cont = new AddContext();
        cont.setTargetContainer((ContainerShape)this.getFeatureProvider().getDiagram());
        cont.setNewObject((Object)newEntity);
        cont.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ft.add((IAddContext)cont);
        return null;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        PersistentType superclass = this.getPersistentType(context.getSourceAnchor());
        return superclass != null;
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.add_inherited_entity";
    }

    protected PersistentType getPersistentType(Anchor anchor) {
        Object refObject;
        if (anchor != null && (refObject = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof PersistentType) {
            return (PersistentType)refObject;
        }
        return null;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void endConnecting() {
        super.endConnecting();
        this.getFeatureProvider().setOriginalPersistentTypeColor();
    }

    public void startConnecting() {
        super.startConnecting();
        this.disableAllNotValidJPTs();
    }

    private void disableAllNotValidJPTs() {
        Diagram d = this.getDiagram();
        JpaProject project = ModelIntegrationUtil.getProjectByDiagram(d.getName());
        PersistenceUnit unit = (PersistenceUnit)project.getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        this.disableAllEmbeddables(unit);
    }

    private void disableAllEmbeddables(PersistenceUnit unit) {
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            if (!JpaArtifactFactory.instance().isEmbeddable((PersistentType)jpt)) continue;
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }
}

