/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IBidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class OneToOneBiDirRelation
extends OneToOneRelation
implements IBidirectionalRelation {
    public OneToOneBiDirRelation(IJPAEditorFeatureProvider fp, PersistentType owner, PersistentType inverse, String ownerAttributeName, String inverseAttributeName, boolean createAttribs, PersistentType embeddingEntity, boolean isDerivedIdFeature) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        this.inverseAttributeName = inverseAttributeName;
        if (createAttribs) {
            this.createRelation(fp, embeddingEntity, isDerivedIdFeature);
        }
    }

    @Override
    public PersistentAttribute getOwnerAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    @Override
    public void setOwnerAnnotatedAttribute(PersistentAttribute ownerAnnotatedAttribute) {
        this.ownerAnnotatedAttribute = ownerAnnotatedAttribute;
    }

    @Override
    public PersistentAttribute getInverseAnnotatedAttribute() {
        return this.inverseAnnotatedAttribute;
    }

    @Override
    public void setInverseAnnotatedAttribute(PersistentAttribute inverseAnnotatedAttribute) {
        this.inverseAnnotatedAttribute = inverseAnnotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp, PersistentType embeddingEntity, boolean isDerivedIdFeature) {
        this.ownerAnnotatedAttribute = JPAEditorUtil.addAnnotatedAttribute(this.owner, this.inverse, false, null);
        this.inverseAnnotatedAttribute = JpaArtifactFactory.instance().isEmbeddable(this.owner) ? JPAEditorUtil.addAnnotatedAttribute(this.inverse, embeddingEntity, false, null) : JPAEditorUtil.addAnnotatedAttribute(this.inverse, this.owner, false, null);
        JpaArtifactFactory.instance().addOneToOneBidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, this.inverse, this.inverseAnnotatedAttribute);
        if (isDerivedIdFeature) {
            JpaArtifactFactory.instance().calculateDerivedIdAttribute(this.owner, this.inverse, this.ownerAnnotatedAttribute);
        }
    }

    @Override
    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.BI;
    }
}

