/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.parser.html;

import java.util.ArrayList;
import org.eclipse.mylyn.wikitext.internal.parser.html.Html;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public abstract class DocumentProcessor {
    public abstract void process(Document var1);

    protected static void normalizeTextNodes(Element parentElement) {
        ArrayList children = parentElement.childNodes();
        if (!children.isEmpty()) {
            children = new ArrayList(children);
            for (Node child : children) {
                if (!(child instanceof TextNode)) continue;
                TextNode childTextNode = (TextNode)child;
                Node previousSibling = child.previousSibling();
                if (previousSibling instanceof TextNode) {
                    TextNode previousSiblingTextNode = (TextNode)previousSibling;
                    childTextNode.text(previousSiblingTextNode.text() + childTextNode.text());
                    previousSibling.remove();
                }
                String wholeText = childTextNode.getWholeText();
                if (!Html.isWhitespacePreserve(parentElement)) {
                    wholeText = StringUtil.normaliseWhitespace((String)wholeText);
                }
                childTextNode.text(wholeText);
            }
        }
    }
}

