/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.osgi.service.prefs.BackingStoreException;

public class JavaProjectPreferencesInitializer {
    private static Logger log = Logger.getLogger(JavaProjectPreferencesInitializer.class);

    @Inject
    public void addOwnFileExtensionsToJavaBuildResourceCopyFilter(FileExtensionProvider extensionProvider) {
        DefaultScope defaultScope = new DefaultScope();
        defaultScope.getNode("org.eclipse.jdt.launching");
        IEclipsePreferences dnode = defaultScope.getNode("org.eclipse.jdt.core");
        if (dnode == null) {
            return;
        }
        LinkedHashSet filters = Sets.newLinkedHashSet();
        String[] stringArray = dnode.get("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", "").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            String trimmed = filter.trim();
            if (!"".equals(trimmed)) {
                filters.add(trimmed);
            }
            ++n2;
        }
        for (String ext : extensionProvider.getFileExtensions()) {
            filters.add("*." + ext);
        }
        dnode.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", Joiner.on((String)", ").join((Iterable)filters));
        try {
            dnode.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)"Error saving preferences", (Throwable)e);
        }
    }
}

