/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema;

import java.sql.Date;
import java.sql.Timestamp;

public class Util {
    private static int nameCounter;

    public static synchronized String createRandomName() {
        return "GwtOrm$$" + nameCounter++;
    }

    public static String makeSqlFriendly(String name) {
        StringBuilder r = new StringBuilder(name.length() + 8);
        boolean lastWasCap = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!lastWasCap) {
                    r.append('_');
                    lastWasCap = true;
                }
                r.append(Character.toLowerCase(c));
                continue;
            }
            if (c == '_') {
                lastWasCap = true;
                r.append(c);
                continue;
            }
            lastWasCap = false;
            r.append(c);
        }
        return r.toString();
    }

    public static String any(String a, String b) {
        if (a != null && a.length() > 0) {
            return a;
        }
        return b;
    }

    public static boolean samePackage(String aName, String bName) {
        return Util.packageOf(aName).equals(Util.packageOf(bName));
    }

    public static String packageOf(String className) {
        int end = className.lastIndexOf(46);
        if (end < 0) {
            return "";
        }
        return className.substring(0, end);
    }

    public static boolean isSqlPrimitive(Class<?> type) {
        if (type == null || type == Void.TYPE) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type == String.class) {
            return true;
        }
        if (type == Date.class) {
            return true;
        }
        if (type == Timestamp.class) {
            return true;
        }
        return type == byte[].class;
    }

    private Util() {
    }
}

