/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CoverageInstrumentationCallback;
import com.google.javascript.jscomp.FileInstrumentationData;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@GwtIncompatible(value="FileInstrumentationData")
class CoverageInstrumentationPass
implements CompilerPass {
    final AbstractCompiler compiler;
    private Map<String, FileInstrumentationData> instrumentationData;
    private CoverageReach reach;
    private static final String JS_INSTRUMENTATION_EXTERNS_CODE = "var JSCompiler_lcov_executedLines;\nvar JSCompiler_lcov_instrumentedLines;\nvar JSCompiler_lcov_fileNames;\n";

    public CoverageInstrumentationPass(AbstractCompiler compiler, CoverageReach reach) {
        this.compiler = compiler;
        this.reach = reach;
        this.instrumentationData = new LinkedHashMap<String, FileInstrumentationData>();
    }

    private void addHeaderCode(Node script) {
        script.addChildToFront(CoverageInstrumentationPass.createConditionalVarDecl("JSCompiler_lcov_executedLines", script));
        script.addChildToFront(CoverageInstrumentationPass.createConditionalVarDecl("JSCompiler_lcov_instrumentedLines", script));
        script.addChildToFront(CoverageInstrumentationPass.createConditionalVarDecl("JSCompiler_lcov_fileNames", script));
    }

    private Node getInstrumentationExternsNode() {
        Node externsNode = this.compiler.parseSyntheticCode("ExternsCodeForCoverageInstrumentation", JS_INSTRUMENTATION_EXTERNS_CODE);
        return externsNode;
    }

    @Override
    public void process(Node externsNode, Node rootNode) {
        if (rootNode.hasChildren()) {
            NodeTraversal.traverseEs6(this.compiler, rootNode, new CoverageInstrumentationCallback(this.compiler, this.instrumentationData, this.reach));
            Node firstScript = rootNode.getFirstChild();
            Preconditions.checkState((boolean)firstScript.isScript());
            this.addHeaderCode(firstScript);
        }
        externsNode.addChildToBack(this.getInstrumentationExternsNode());
    }

    private static Node createConditionalVarDecl(String name, Node srcref) {
        Node var = IR.var(IR.name(name), IR.or(IR.name(name), IR.arraylit(new Node[0])));
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordSuppressions((Set<String>)ImmutableSet.of((Object)"duplicate"));
        var.setJSDocInfo(builder.build());
        return var.useSourceInfoIfMissingFromForTree(srcref);
    }

    public static enum CoverageReach {
        ALL,
        CONDITIONAL;

    }
}

