/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.xpath10;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.xpath10.Expr;
import org.eclipse.bpel.xpath10.Predicate;

public class FilterExpr
extends Expr {
    List<Predicate> fList = new ArrayList<Predicate>();
    Expr fExpr;

    public FilterExpr(Expr expr) {
        super(expr.toString());
        this.fExpr = expr;
    }

    public Expr getExpr() {
        return this.fExpr;
    }

    public List<Predicate> getPredicates() {
        return this.fList;
    }

    public void addPredicate(Predicate p) {
        this.fList.add(p);
    }

    public boolean hasPredicates() {
        return this.fList.size() > 0;
    }

    @Override
    protected String asText() {
        StringBuilder sb = new StringBuilder();
        if (this.fExpr != null) {
            sb.append(this.fExpr.getText());
        }
        for (Predicate p : this.fList) {
            sb.append(p.getText());
        }
        return sb.toString();
    }

    @Override
    public int getPosition() {
        return this.fExpr != null ? this.fExpr.getPosition() : -1;
    }

    @Override
    public int getEndPosition() {
        return this.fExpr != null ? this.fExpr.getEndPosition() : -1;
    }
}

