/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.lane;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveLaneFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveFromParticipantToParticipantFeature
extends MoveLaneFeature {
    public MoveFromParticipantToParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        Participant p2;
        Participant p1 = (Participant)this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
        if (p1.equals(p2 = (Participant)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer()))) {
            return false;
        }
        if (this.getMovedLane(context).getFlowNodeRefs().isEmpty()) {
            return true;
        }
        if (p2.getProcessRef() == null) {
            return true;
        }
        return !p2.getProcessRef().getLaneSets().isEmpty();
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        this.modifyModelStructure(context);
        this.layoutPictogramElement((PictogramElement)context.getSourceContainer());
        this.layoutPictogramElement((PictogramElement)context.getTargetContainer());
    }

    private void modifyModelStructure(IMoveShapeContext context) {
        Lane movedLane = this.getMovedLane(context);
        Process sourceProcess = this.getProcess(context.getSourceContainer());
        Process targetProcess = this.getProcess(context.getTargetContainer());
        this.moveLane(movedLane, sourceProcess, targetProcess);
        for (LaneSet laneSet : sourceProcess.getLaneSets()) {
            if (!laneSet.getLanes().contains(movedLane)) continue;
            laneSet.getLanes().remove(movedLane);
            if (laneSet.getLanes().isEmpty()) {
                sourceProcess.getLaneSets().remove(laneSet);
            }
            if (targetProcess.getLaneSets().isEmpty()) {
                LaneSet newLaneSet = this.createLaneSet();
                targetProcess.getLaneSets().add(newLaneSet);
            }
            ((LaneSet)targetProcess.getLaneSets().get(0)).getLanes().add(movedLane);
            break;
        }
    }
}

