/*******************************************************************************
 * Copyright (c) 2011-2017 Red Hat, Inc.
 * All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Red Hat, Inc. - initial API and implementation
 *
 * @author Bob Brodt
 ******************************************************************************/

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.drools.core.process.core.ParameterDefinition;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.WorkDefinition;
import org.drools.core.process.core.WorkEditor;
import org.drools.core.process.core.impl.WorkImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This sample Work Item editor was generated by the BPMN2 Modeler.
 * Please customize for your own needs.
 */
public class SampleWorkItemEditor extends Dialog implements WorkEditor {

	private Work work;
	private WorkDefinition workDefinition;
    private Map<String, Text> texts = new HashMap<String, Text>();
    
    public SampleWorkItemEditor(Shell parentShell) {
        super(parentShell);
        setShellStyle(getShellStyle() | SWT.RESIZE);
        setBlockOnOpen(true);
    }
    
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Sample Work Item Editor");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite) super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        
        Label nameLabel = new Label(composite, SWT.NONE);
        nameLabel.setText("Name: ");
        Text nameText = new Text(composite, SWT.NONE);
        nameText.setEditable(false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = GridData.FILL;
        nameText.setLayoutData(gridData);
        String name = work.getName();
        nameText.setText(name == null ? "" : name);
        
        List<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();
        parameters.addAll(workDefinition.getParameters());
        parameters.sort(new Comparator<ParameterDefinition>() {

			public int compare(ParameterDefinition o1, ParameterDefinition o2) {
				return o1.getName().compareTo(o2.getName());
			}
		});
        for (ParameterDefinition param: parameters) {
            Label label = new Label(composite, SWT.NONE);
            label.setText(param.getName() + ": ");
            Text text = new Text(composite, SWT.BORDER);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = GridData.FILL;
            text.setLayoutData(gridData);
            texts.put(param.getName(), text);
            Object value = work.getParameter(param.getName());
            text.setText(value == null ? "" : value.toString());
        }
        
        return composite;
    }

    protected Point getInitialSize() {
    	return getShell().computeSize(-1, -1);
    }

    protected Work updateValue(Work value) {
        Work work = new WorkImpl();
        work.setName(value.getName());
        for (Map.Entry<String, Text> entry: texts.entrySet()) {
            String text = entry.getValue().getText();
            work.setParameter(entry.getKey(), "".equals(text) ? null : text);
        }
        work.setParameterDefinitions(value.getParameterDefinitions());
        return work;
    }
        
    public Work getWork() {
        return work;
    }
    
    public void setWork(Work work) {
        this.work = work;
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
    }

    public boolean show() {
        return open() == OK;
    }
    
    protected void okPressed() {
        try {
            work = updateValue(work);
            super.okPressed();
        } catch (IllegalArgumentException e) {
            showError(e.getMessage());
            // value could not be set, ignoring ok
        }
    }
    
    protected void showError(String error) {
        MessageDialog.openError(getShell(), "Error", error); //$NON-NLS-1$
    }
}
