/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.cdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RefactoringExecutionHelper {
    private final Refactoring fRefactoring;
    private final Shell fParent;
    private final IRunnableContext fExecContext;
    private final int fSaveMode;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSeverity, int saveMode, Shell parent, IRunnableContext context) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)context);
        this.fRefactoring = refactoring;
        this.fParent = parent;
        this.fExecContext = context;
        this.fSaveMode = saveMode;
    }

    public void performChange(Change change, boolean fork) throws InterruptedException, InvocationTargetException {
        PerformChangeOperation operation = this.createPerformChangeOperation(change);
        this.performOperation(operation, fork);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performOperation(PerformChangeOperation changeOperation, boolean fork) throws InterruptedException, InvocationTargetException {
        Assert.isTrue((changeOperation != null ? 1 : 0) != 0);
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        IJobManager manager = Job.getJobManager();
        ISchedulingRule rule = this.getSchedulingRule();
        try {
            try {
                Runnable r = () -> manager.beginRule(rule, null);
                BusyIndicator.showWhile((Display)this.fParent.getDisplay(), (Runnable)r);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(this.fSaveMode);
            this.fRefactoring.setValidationContext((Object)this.fParent);
            try {
                try {
                    RefactoringStatus validationStatus;
                    if (fork) {
                        this.fExecContext.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)changeOperation, rule, true));
                    }
                    if ((validationStatus = changeOperation.getValidationStatus()) == null || !validationStatus.hasFatalError()) return;
                    MessageDialog.openError((Shell)this.fParent, (String)this.fRefactoring.getName(), (String)NLS.bind((String)Messages.RefactoringExecutionHelper_cannot_execute, (Object)validationStatus.getMessageMatchingSeverity(4)));
                    throw new InterruptedException();
                }
                catch (InvocationTargetException e) {
                    if (!changeOperation.changeExecutionFailed()) throw e;
                    ChangeExceptionHandler handler = new ChangeExceptionHandler(this.fParent, this.fRefactoring);
                    Throwable inner = e.getTargetException();
                    if (inner instanceof RuntimeException) {
                        handler.handle(changeOperation.getChange(), (RuntimeException)inner);
                    } else {
                        if (!(inner instanceof CoreException)) throw e;
                        handler.handle(changeOperation.getChange(), (CoreException)inner);
                    }
                    saveHelper.triggerIncrementalBuild();
                    return;
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
            finally {
                saveHelper.triggerIncrementalBuild();
            }
        }
        finally {
            manager.endRule(rule);
            this.fRefactoring.setValidationContext(null);
        }
    }

    private ISchedulingRule getSchedulingRule() {
        if (this.fRefactoring instanceof IScheduledRefactoring) {
            return ((IScheduledRefactoring)this.fRefactoring).getSchedulingRule();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private PerformChangeOperation createPerformChangeOperation(Change change) {
        PerformChangeOperation operation = new PerformChangeOperation(change);
        operation.setUndoManager(RefactoringCore.getUndoManager(), this.fRefactoring.getName());
        if (this.fRefactoring instanceof IScheduledRefactoring) {
            operation.setSchedulingRule(((IScheduledRefactoring)this.fRefactoring).getSchedulingRule());
        }
        return operation;
    }
}

