/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.cdt.internal.ui.text.correction.proposals.RenameRefactoringProposal;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IInvocationContext;
import org.eclipse.cdt.ui.text.IProblemLocation;
import org.eclipse.cdt.ui.text.IQuickAssistProcessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorPart;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    @Override
    public boolean hasAssists(final IInvocationContext context) throws CoreException {
        IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)context.getTranslationUnit(), ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor(), new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) throws CoreException {
                IBinding binding;
                IASTNodeSelector selector = astRoot.getNodeSelector(null);
                IASTName name = selector.findEnclosingName(context.getSelectionOffset(), context.getSelectionLength());
                if (name != null && name == name.getLastName() && (binding = name.resolveBinding()) != null) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        });
        return status.isOK();
    }

    @Override
    public ICCompletionProposal[] getAssists(final IInvocationContext context, final IProblemLocation[] problemLocations) throws CoreException {
        final ArrayList proposals = new ArrayList();
        ASTProvider.getASTProvider().runOnAST((ICElement)context.getTranslationUnit(), ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor(), new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) throws CoreException {
                IBinding binding;
                if (astRoot == null) {
                    return Status.CANCEL_STATUS;
                }
                IASTNodeSelector selector = astRoot.getNodeSelector(null);
                IASTName name = selector.findEnclosingName(context.getSelectionOffset(), context.getSelectionLength());
                if (name != null && name == name.getLastName() && (binding = name.resolveBinding()) != null) {
                    boolean noErrorsAtLocation = QuickAssistProcessor.this.noErrorsAtLocation(problemLocations);
                    QuickAssistProcessor.getRenameLocalProposals(context, problemLocations, noErrorsAtLocation, proposals);
                    QuickAssistProcessor.getRenameRefactoringProposal(context, problemLocations, noErrorsAtLocation, proposals);
                }
                return Status.OK_STATUS;
            }
        });
        return proposals.isEmpty() ? null : proposals.toArray(new ICCompletionProposal[proposals.size()]);
    }

    private boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                if (locations[i].isError()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static void getRenameLocalProposals(IInvocationContext context, IProblemLocation[] locations, boolean noErrorsAtLocation, Collection<ICCompletionProposal> proposals) {
        LinkedNamesAssistProposal proposal = new LinkedNamesAssistProposal(context.getTranslationUnit());
        if (!noErrorsAtLocation) {
            proposal.setRelevance(1);
        }
        proposals.add(proposal);
    }

    private static boolean getRenameRefactoringProposal(IInvocationContext context, IProblemLocation[] locations, boolean noErrorsAtLocation, Collection<ICCompletionProposal> proposals) throws CoreException {
        IEditorPart editor = CUIPlugin.getActivePage().getActiveEditor();
        if (!(editor instanceof CEditor)) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        RenameRefactoringProposal proposal = new RenameRefactoringProposal((CEditor)editor);
        if (!noErrorsAtLocation) {
            proposal.setRelevance(1);
        }
        proposals.add(proposal);
        return true;
    }
}

