/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.RepositoryCacheRule;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/egit/ui/APPLICATION_ACTIVE"})
public class ExternalRepositoryScanner
implements EventHandler {
    private AtomicBoolean isActive = new AtomicBoolean();
    private ResourceRefreshJob refreshJob;
    private RepositoryChangeScanner scanner;

    public void handleEvent(Event event) {
        boolean newValue;
        Object value;
        if ("org/eclipse/egit/ui/APPLICATION_ACTIVE".equals(event.getTopic()) && (value = event.getProperty("org.eclipse.e4.data")) instanceof Boolean && this.isActive.compareAndSet(!(newValue = ((Boolean)value).booleanValue()), newValue) && newValue) {
            this.scanner.schedule();
        }
    }

    @Activate
    void startUp() {
        this.refreshJob = new ResourceRefreshJob();
        this.scanner = new RepositoryChangeScanner(this.refreshJob, this.isActive);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.scanner);
    }

    @Deactivate
    void shutDown() {
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.scanner.getName() + " job");
        }
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.scanner);
        this.scanner.setReschedule(false);
        this.scanner.cancel();
        this.refreshJob.cancel();
        try {
            this.scanner.join();
            this.refreshJob.join();
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Jobs terminated");
            }
        }
        catch (InterruptedException e) {
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Jobs termination interrupted");
            }
            Thread.currentThread().interrupt();
        }
    }

    private static class RepositoryChangeScanner
    extends Job
    implements IPropertyChangeListener {
        private volatile boolean doReschedule;
        private volatile int interval;
        private final ResourceRefreshJob refresher;
        private final AtomicBoolean workbenchActive;
        private final RepositoryCache repositoryCache;
        private Collection<WorkingTreeModifiedEvent> events;
        private final IndexChangedListener listener = event -> {
            if (event.isInternal()) {
                return;
            }
            Repository repository = event.getRepository();
            if (repository.isBare()) {
                return;
            }
            ArrayList<String> directories = new ArrayList<String>();
            IProject[] iProjectArray = RuleUtil.getProjects((Repository)repository);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String repoRelativePath;
                RepositoryMapping mapping;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (mapping = RepositoryMapping.getMapping((IProject)project)) != null && repository == mapping.getRepository() && (repoRelativePath = mapping.getRepoRelativePath((IResource)project)) != null) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning project " + project.getName());
                    }
                    try {
                        Throwable throwable = null;
                        Object var11_13 = null;
                        try (TreeWalk w = new TreeWalk(repository);){
                            w.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                            if (!repoRelativePath.isEmpty()) {
                                w.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}));
                            } else {
                                directories.add("/");
                            }
                            w.setRecursive(false);
                            while (w.next()) {
                                FileTreeIterator iter;
                                if (!w.isSubtree() || (iter = (FileTreeIterator)w.getTree(0, FileTreeIterator.class)) == null || iter.isEntryIgnored()) continue;
                                directories.add(String.valueOf(w.getPathString()) + '/');
                                w.enterSubtree();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanned project " + project.getName());
                    }
                }
                ++n2;
            }
            if (directories.isEmpty()) {
                return;
            }
            WorkingTreeModifiedEvent evt = new WorkingTreeModifiedEvent(directories, null);
            evt.setRepository(repository);
            this.events.add(evt);
        };

        public RepositoryChangeScanner(ResourceRefreshJob refresher, AtomicBoolean workbenchActive) {
            super(UIText.Activator_repoScanJobName);
            this.refresher = refresher;
            this.workbenchActive = workbenchActive;
            this.setRule(new RepositoryCacheRule());
            this.setSystem(true);
            this.setUser(false);
            this.repositoryCache = RepositoryCache.getInstance();
            this.updateRefreshInterval();
        }

        public boolean shouldSchedule() {
            return this.doReschedule;
        }

        public boolean shouldRun() {
            return this.doReschedule;
        }

        public void setReschedule(boolean reschedule) {
            this.doReschedule = reschedule;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") && !this.workbenchActive.get()) {
                monitor.done();
                return Status.OK_STATUS;
            }
            Repository[] repos = this.repositoryCache.getAllRepositories();
            if (repos.length == 0) {
                this.schedule(this.interval);
                return Status.OK_STATUS;
            }
            monitor.beginTask(UIText.Activator_scanningRepositories, repos.length);
            try {
                try {
                    this.events = new ArrayList<WorkingTreeModifiedEvent>();
                    Repository[] repositoryArray = repos;
                    int n = repos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Repository repo = repositoryArray[n2];
                        if (monitor.isCanceled()) break;
                        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning " + repo + " for changes");
                        }
                        if (!repo.isBare()) {
                            ListenerHandle handle = null;
                            try {
                                handle = repo.getListenerList().addIndexChangedListener(this.listener);
                                repo.scanForRepoChanges();
                            }
                            finally {
                                if (handle != null) {
                                    handle.remove();
                                }
                            }
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                    if (!monitor.isCanceled()) {
                        this.refresher.trigger(this.events);
                    }
                    this.events.clear();
                }
                catch (IOException e) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Stopped rescheduling " + this.getName() + " job");
                    }
                    IStatus iStatus = Activator.createErrorStatus(UIText.Activator_scanError, e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Rescheduling " + this.getName() + " job");
            }
            this.schedule(this.interval);
            return Status.OK_STATUS;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!"refesh_index_interval".equals(event.getProperty())) {
                return;
            }
            this.updateRefreshInterval();
        }

        private void updateRefreshInterval() {
            this.interval = RepositoryChangeScanner.getRefreshIndexInterval();
            this.setReschedule(this.interval > 0);
            this.cancel();
            this.schedule(this.interval);
        }

        private static int getRefreshIndexInterval() {
            return 1000 * Activator.getDefault().getPreferenceStore().getInt("refesh_index_interval");
        }
    }

    private static class ResourceRefreshJob
    extends Job {
        private Map<File, WorkingTreeChanges> repositoriesChanged = new LinkedHashMap<File, WorkingTreeChanges>();

        public ResourceRefreshJob() {
            super(UIText.Activator_refreshJobName);
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * Exception decompiling
         */
        public IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 18[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trigger(Collection<WorkingTreeModifiedEvent> events) {
            boolean haveChanges = false;
            for (WorkingTreeModifiedEvent event : events) {
                Repository repo;
                if (event.isEmpty() || (repo = event.getRepository()) == null || repo.isBare()) continue;
                File gitDir = repo.getDirectory();
                Map<File, WorkingTreeChanges> map = this.repositoriesChanged;
                synchronized (map) {
                    WorkingTreeChanges changes = this.repositoriesChanged.get(gitDir);
                    if (changes == null) {
                        this.repositoriesChanged.put(gitDir, new WorkingTreeChanges(event));
                    } else {
                        changes.merge(event);
                        if (changes.isEmpty()) {
                            this.repositoriesChanged.remove(gitDir);
                        }
                    }
                }
                haveChanges = true;
            }
            if (haveChanges) {
                this.schedule();
            }
        }

        private static class WorkingTreeChanges {
            private final File gitDir;
            private final Set<String> modified;
            private final Set<String> deleted;

            public WorkingTreeChanges(WorkingTreeModifiedEvent event) {
                this.gitDir = event.getRepository().getDirectory();
                this.modified = new HashSet<String>(event.getModified());
                this.deleted = new HashSet<String>(event.getDeleted());
            }

            public File getGitDirectory() {
                return this.gitDir;
            }

            public Set<String> getModified() {
                return this.modified;
            }

            public Set<String> getDeleted() {
                return this.deleted;
            }

            public boolean isEmpty() {
                return this.modified.isEmpty() && this.deleted.isEmpty();
            }

            public WorkingTreeChanges merge(WorkingTreeModifiedEvent event) {
                this.modified.removeAll(event.getDeleted());
                this.deleted.removeAll(event.getModified());
                this.modified.addAll(event.getModified());
                this.deleted.addAll(event.getDeleted());
                return this;
            }
        }
    }
}

