/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.efs.EgitFileSystem;
import org.eclipse.egit.core.internal.efs.HiddenResources;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.CompareEditorInputViewerAction;
import org.eclipse.egit.ui.internal.merge.MergeDiffNode;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.egit.ui.internal.merge.ToggleCurrentChangesAction;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.revision.ResourceEditableRevision;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public class GitMergeEditorInput
extends CompareEditorInput {
    private static final String LABELPATTERN = "{0} - {1}";
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image PROJECT_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    private final MergeInputMode mode;
    private final boolean useWorkspace;
    private final boolean useOurs;
    private final IPath[] locations;
    private List<IFile> toDelete;
    private Map<String, IHandlerActivation> activations = new HashMap<String, IHandlerActivation>();
    private CompareEditorInputViewerAction toggleCurrentChanges;

    public GitMergeEditorInput(MergeInputMode mode, IPath ... locations) {
        super(new CompareConfiguration());
        this.useWorkspace = !MergeInputMode.STAGE_2.equals((Object)mode);
        this.useOurs = MergeInputMode.MERGED_OURS.equals((Object)mode);
        this.mode = mode;
        this.locations = locations;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setLeftEditable(true);
    }

    public Object getAdapter(Class adapter) {
        Object selectedEdition;
        if ((adapter == IFile.class || adapter == IResource.class) && GitMergeEditorInput.isUIThread() && (selectedEdition = this.getSelectedEdition()) instanceof DiffNode) {
            DiffNode diffNode = (DiffNode)selectedEdition;
            ITypedElement element = diffNode.getLeft();
            IFile resource = null;
            if (element instanceof HiddenResourceTypedElement) {
                resource = ((HiddenResourceTypedElement)element).getRealFile();
            }
            if (resource == null && element instanceof IResourceProvider) {
                resource = ((IResourceProvider)element).getResource();
            }
            if (resource != null && adapter.isInstance(resource)) {
                return resource;
            }
        }
        return super.getAdapter(adapter);
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.getNavigator().selectChange(true);
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        ToolBarManager manager = CompareViewerPane.getToolBarManager((Composite)parent);
        if (manager != null) {
            this.setToggleCurrentChangesAction(manager, newViewer, input);
        }
        return newViewer;
    }

    private void setToggleCurrentChangesAction(ToolBarManager manager, Viewer newViewer, ICompareInput input) {
        boolean isApplicable = newViewer instanceof ContentMergeViewer && input instanceof MergeDiffNode && input.getAncestor() != null;
        this.setAction(manager, newViewer, isApplicable, "org.eclipse.egit.ui.internal.merge.ToggleCurrentChangesCommand", create -> {
            if (this.toggleCurrentChanges == null && create) {
                this.toggleCurrentChanges = new ToggleCurrentChangesAction(UIText.GitMergeEditorInput_ToggleCurrentChangesLabel, this);
                this.toggleCurrentChanges.setId("org.eclipse.egit.ui.internal.merge.ToggleCurrentChangesCommand");
            }
            return this.toggleCurrentChanges;
        });
    }

    private void setAction(ToolBarManager manager, Viewer viewer, boolean isApplicable, String id, ActionSupplier supplier) {
        IContributionItem item = manager.find(id);
        if (item != null) {
            IAction action;
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof CompareEditorInputViewerAction) {
                ((CompareEditorInputViewerAction)action).setViewer(isApplicable ? (ContentMergeViewer)viewer : null);
                action.setEnabled(isApplicable);
                if (item.isVisible() != isApplicable) {
                    item.setVisible(isApplicable);
                    manager.update(true);
                }
            }
        } else if (isApplicable) {
            CompareEditorInputViewerAction action = supplier.get(true);
            action.setViewer((ContentMergeViewer)viewer);
            action.setEnabled(true);
            manager.insert(0, (IContributionItem)new ActionContributionItem((IAction)action));
            manager.update(true);
            this.registerAction((IAction)action, id);
        } else {
            CompareEditorInputViewerAction action = supplier.get(false);
            if (action != null) {
                action.setEnabled(false);
            }
        }
    }

    private void registerAction(IAction action, String commandId) {
        IHandlerService handlers;
        if (this.activations.containsKey(commandId)) {
            return;
        }
        action.setActionDefinitionId(commandId);
        IServiceLocator locator = this.getContainer().getServiceLocator();
        if (locator != null && (handlers = (IHandlerService)locator.getService(IHandlerService.class)) != null) {
            this.activations.put(commandId, handlers.activateHandler(commandId, (IHandler)new ActionHandler(action)));
        }
    }

    protected void handleDispose() {
        super.handleDispose();
        this.activations.values().forEach(a -> a.getHandlerService().deactivateHandler(a));
        this.activations.clear();
        if (this.toggleCurrentChanges != null) {
            this.toggleCurrentChanges.dispose();
            this.toggleCurrentChanges = null;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(this::cleanUp);
    }

    private void cleanUp() {
        if (this.toDelete == null || this.toDelete.isEmpty()) {
            return;
        }
        final List<IFile> toClean = this.toDelete;
        this.toDelete = null;
        Job job = new Job(UIText.GitMergeEditorInput_ResourceCleanupJobName){

            public boolean shouldSchedule() {
                return super.shouldSchedule() && !PlatformUI.getWorkbench().isClosing();
            }

            public boolean shouldRun() {
                return super.shouldRun() && !PlatformUI.getWorkbench().isClosing();
            }

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRunnable remove = m -> {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)toClean.size());
                    for (IFile tmp : toClean) {
                        if (PlatformUI.getWorkbench().isClosing()) {
                            return;
                        }
                        try {
                            tmp.delete(true, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(remove, null, 1, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    private static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RevWalk rw = null;
        try {
            String fullBranch;
            RevCommit headCommit;
            RevCommit rightCommit;
            monitor.beginTask(UIText.GitMergeEditorInput_CheckingResourcesTaskName, -1);
            Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(this.locations));
            if (pathsByRepository.size() != 1) {
                throw new InvocationTargetException(new IllegalStateException(UIText.RepositoryAction_multiRepoSelection));
            }
            Map.Entry entry = pathsByRepository.entrySet().iterator().next();
            Repository repo = (Repository)entry.getKey();
            ArrayList<String> filterPaths = new ArrayList<String>((Collection)entry.getValue());
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            rw = new RevWalk(repo);
            try {
                rightCommit = RevCommitUtils.getTheirs((Repository)repo, (RevWalk)rw);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                ObjectId head = repo.resolve("HEAD");
                if (head == null) {
                    throw new IOException(NLS.bind((String)CoreText.ValidationUtils_CanNotResolveRefMessage, (Object)"HEAD"));
                }
                headCommit = rw.parseCommit((AnyObjectId)head);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                fullBranch = repo.getFullBranch();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            CompareConfiguration config = this.getCompareConfiguration();
            RevCommit ancestorCommit = null;
            boolean unknownAncestor = false;
            switch (repo.getRepositoryState()) {
                case CHERRY_PICKING: 
                case REBASING_MERGE: 
                case REBASING_INTERACTIVE: {
                    if (rightCommit.getParentCount() == 1) {
                        try {
                            ancestorCommit = rw.parseCommit((AnyObjectId)rightCommit.getParent(0));
                        }
                        catch (IOException e) {
                            unknownAncestor = true;
                        }
                    } else {
                        unknownAncestor = true;
                    }
                    if (MergeInputMode.WORKTREE.equals((Object)this.mode)) break;
                    config.setChangeIgnored(config.isMirrored() ? 2 : 3, true);
                    config.setChangeIgnored(4, true);
                    break;
                }
                default: {
                    ArrayList<RevCommit> startPoints = new ArrayList<RevCommit>();
                    rw.setRevFilter(RevFilter.MERGE_BASE);
                    startPoints.add(rightCommit);
                    startPoints.add(headCommit);
                    try {
                        rw.markStart(startPoints);
                        ancestorCommit = rw.next();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            config.setRightLabel(NLS.bind((String)LABELPATTERN, (Object)rightCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(rightCommit.name())));
            if (!this.useWorkspace) {
                config.setLeftLabel(NLS.bind((String)LABELPATTERN, (Object)headCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(headCommit.name())));
            } else if (this.useOurs) {
                config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceOursHeader);
            } else {
                config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceHeader);
            }
            if (ancestorCommit != null) {
                config.setAncestorLabel(NLS.bind((String)LABELPATTERN, (Object)ancestorCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(ancestorCommit.name())));
            } else if (unknownAncestor) {
                config.setAncestorLabel(NLS.bind((String)UIText.GitMergeEditorInput_AncestorUnknownHeader, (Object)CompareUtils.truncatedRevision(rightCommit.name())));
            }
            this.setTitle(NLS.bind((String)UIText.GitMergeEditorInput_MergeEditorTitle, (Object[])new Object[]{RepositoryUtil.getInstance().getRepositoryName(repo), rightCommit.getShortMessage(), fullBranch}));
            try {
                IDiffContainer iDiffContainer = this.buildDiffContainer(repo, headCommit, ancestorCommit, filterPaths, rw, monitor);
                return iDiffContainer;
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (rw != null) {
                rw.dispose();
            }
            monitor.done();
        }
    }

    private IDiffContainer buildDiffContainer(Repository repository, RevCommit headCommit, RevCommit ancestorCommit, List<String> filterPaths, RevWalk rw, IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.setTaskName(UIText.GitMergeEditorInput_CalculatingDiffTaskName);
        DiffNode result = new DiffNode(12);
        MergeCommand.ConflictStyle style = null;
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (TreeWalk tw = new TreeWalk(repository);){
                int dirCacheIndex = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
                FileTreeIterator fIter = new FileTreeIterator(repository);
                int fileTreeIndex = tw.addTree((AbstractTreeIterator)fIter);
                fIter.setDirCacheIterator(tw, dirCacheIndex);
                int repositoryTreeIndex = tw.addTree((AnyObjectId)rw.parseTree((AnyObjectId)repository.resolve("HEAD")));
                if (!filterPaths.isEmpty()) {
                    if (filterPaths.size() > 1) {
                        tw.setFilter(PathFilterGroup.createFromStrings(filterPaths));
                    } else {
                        String path = filterPaths.get(0);
                        if (!path.isEmpty()) {
                            tw.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{path}));
                        }
                    }
                }
                tw.setRecursive(true);
                while (tw.next()) {
                    ResourceEditableRevision left;
                    boolean useWorkingTree;
                    ITypedElement right;
                    boolean modified;
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    String gitPath = tw.getPathString();
                    monitor.setTaskName(gitPath);
                    FileTreeIterator fit = (FileTreeIterator)tw.getTree(fileTreeIndex, FileTreeIterator.class);
                    if (fit == null) continue;
                    DirCacheIterator dit = (DirCacheIterator)tw.getTree(dirCacheIndex, DirCacheIterator.class);
                    DirCacheEntry dirCacheEntry = dit == null ? null : dit.getDirCacheEntry();
                    boolean conflicting = dirCacheEntry != null && dirCacheEntry.getStage() > 0;
                    AbstractTreeIterator rt = tw.getTree(repositoryTreeIndex, AbstractTreeIterator.class);
                    boolean bl = modified = rt != null && !fit.getEntryObjectId().equals((AnyObjectId)rt.getEntryObjectId());
                    if (!conflicting && !modified) continue;
                    String encoding = null;
                    if (conflicting) {
                        GitFileRevision revision = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)3);
                        encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                        right = new FileRevisionTypedElement((IFileRevision)revision, encoding);
                    } else {
                        right = CompareUtils.getFileRevisionTypedElement(gitPath, headCommit, repository);
                    }
                    if (right instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) continue;
                    Path repositoryPath = new Path(repository.getWorkTree().getAbsolutePath());
                    IPath location = repositoryPath.append(gitPath);
                    assert (location != null);
                    final IFile file = ResourceUtil.getFileForLocation((IPath)location, (boolean)false);
                    boolean bl2 = useWorkingTree = !conflicting || this.useWorkspace;
                    if (!useWorkingTree && conflicting && dirCacheEntry != null) {
                        boolean bl3 = useWorkingTree = !Instant.EPOCH.equals(dirCacheEntry.getLastModifiedInstant());
                    }
                    if (useWorkingTree) {
                        Object item;
                        Attribute markerSize;
                        Attributes attributes;
                        boolean useOursFilter = conflicting && this.useOurs;
                        int conflictMarkerSize = 7;
                        if (useOursFilter && (useOursFilter = (attributes = tw.getAttributes()).canBeContentMerged()) && (markerSize = attributes.get("conflict-marker-size")) != null && Attribute.State.CUSTOM.equals((Object)markerSize.getState())) {
                            try {
                                conflictMarkerSize = Integer.parseUnsignedInt(markerSize.getValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (useOursFilter) {
                            boolean useDiff3Style;
                            if (style == null) {
                                style = (MergeCommand.ConflictStyle)repository.getConfig().getEnum("merge", null, "conflictStyle", (Enum)MergeCommand.ConflictStyle.MERGE);
                            }
                            String filter = String.valueOf((useDiff3Style = MergeCommand.ConflictStyle.DIFF3.equals(style)) ? (char)'O' : 'o') + Integer.toString(conflictMarkerSize);
                            URI uri = EgitFileSystem.createURI((Repository)repository, (String)gitPath, (String)("WORKTREE:" + filter));
                            Charset rscEncoding = null;
                            if (file != null) {
                                if (encoding == null) {
                                    encoding = CompareCoreUtils.getResourceEncoding((IResource)file);
                                }
                                try {
                                    rscEncoding = Charset.forName(encoding);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                            item = this.createWithHiddenResource(uri, tw.getNameString(), file, rscEncoding);
                            if (file != null) {
                                item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new LocalResourceSaver((LocalResourceTypedElement)item){

                                    @Override
                                    protected void save() throws CoreException {
                                        super.save();
                                        file.refreshLocal(0, null);
                                    }
                                });
                            } else {
                                item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new LocalResourceSaver((LocalResourceTypedElement)item));
                            }
                        } else {
                            item = file != null ? new LocalResourceTypedElement((IResource)file) : new LocalNonWorkspaceTypedElement(repository, location);
                            item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new LocalResourceSaver((LocalResourceTypedElement)item));
                        }
                        left = item;
                    } else {
                        IFile rsc;
                        IFile iFile = rsc = file != null ? file : this.createHiddenResource(location.toFile().toURI(), tw.getNameString(), null);
                        assert (rsc != null);
                        GitFileRevision rev = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)2);
                        ICompareContainer runnableContext = this.getContainer();
                        if (runnableContext == null) {
                            runnableContext = PlatformUI.getWorkbench().getProgressService();
                            assert (runnableContext != null);
                        }
                        left = new ResourceEditableRevision((IFileRevision)rev, rsc, (IRunnableContext)runnableContext);
                        ((EditableRevision)left).addContentChangeListener(source -> this.updateIndexTimestamp(repository, gitPath));
                        try {
                            ((EditableRevision)left).cacheContents(monitor);
                        }
                        catch (CoreException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                    int kind = 0;
                    if (conflicting) {
                        kind = 12;
                    } else if (modified) {
                        kind = 16;
                    }
                    IDiffContainer fileParent = this.getFileParent((IDiffContainer)result, (IPath)repositoryPath, file, location);
                    ITypedElement ancestor = null;
                    if (ancestorCommit != null) {
                        ancestor = CompareUtils.getFileRevisionTypedElement(gitPath, ancestorCommit, repository);
                        if (ancestor instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) {
                            ancestor = null;
                        }
                    } else if (conflicting) {
                        GitFileRevision revision = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)1);
                        if (encoding == null) {
                            encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                        }
                        ancestor = new FileRevisionTypedElement((IFileRevision)revision, encoding);
                    }
                    new MergeDiffNode(fileParent, kind, ancestor, left, right);
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private LocalResourceTypedElement createWithHiddenResource(URI uri, String name, IFile file, Charset encoding) throws IOException {
        IFile tmp = this.createHiddenResource(uri, name, encoding);
        return new HiddenResourceTypedElement(tmp, file);
    }

    private IFile createHiddenResource(URI uri, String name, Charset encoding) throws IOException {
        try {
            IFile tmp = HiddenResources.INSTANCE.createFile(uri, name, encoding, null);
            if (this.toDelete == null) {
                this.toDelete = new ArrayList<IFile>();
            }
            this.toDelete.add(tmp);
            return tmp;
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void updateIndexTimestamp(Repository repository, String gitPath) {
        DirCache cache = null;
        try {
            try {
                cache = repository.lockDirCache();
                DirCacheEditor editor = cache.editor();
                editor.add(new DirCacheEditor.PathEdit(gitPath){
                    private boolean done;

                    public void apply(DirCacheEntry ent) {
                        if (!this.done && ent.getStage() > 0) {
                            ent.setLastModified(Instant.now());
                            this.done = true;
                        }
                    }
                });
                editor.commit();
            }
            catch (IOException e) {
                Activator.logError(MessageFormat.format(UIText.GitMergeEditorInput_ErrorUpdatingIndex, gitPath), e);
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        finally {
            if (cache != null) {
                cache.unlock();
            }
        }
    }

    private IDiffContainer getFileParent(IDiffContainer root, IPath repositoryPath, IFile file, IPath location) {
        IProject project;
        IPath projectLocation;
        int projectSegment = -1;
        String projectName = null;
        if (file != null && (projectLocation = (project = file.getProject()).getLocation()) != null) {
            IPath projectPath = project.getLocation().makeRelativeTo(repositoryPath);
            projectSegment = projectPath.segmentCount() - 1;
            projectName = project.getName();
        }
        IPath path = location.makeRelativeTo(repositoryPath);
        IDiffContainer child = root;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            child = i == projectSegment ? this.getOrCreateChild(child, projectName, true) : this.getOrCreateChild(child, path.segment(i), false);
            ++i;
        }
        return child;
    }

    private DiffNode getOrCreateChild(IDiffContainer parent, final String name, final boolean projectMode) {
        Object child;
        IDiffElement[] iDiffElementArray = parent.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iDiffElementArray[n2];
            if (child.getName().equals(name)) {
                return (DiffNode)child;
            }
            ++n2;
        }
        child = new DiffNode(parent, 0){

            public String getName() {
                return name;
            }

            public Image getImage() {
                if (projectMode) {
                    return PROJECT_IMAGE;
                }
                return FOLDER_IMAGE;
            }
        };
        return child;
    }

    public boolean canRunAsJob() {
        return true;
    }

    @FunctionalInterface
    private static interface ActionSupplier {
        public CompareEditorInputViewerAction get(boolean var1);
    }

    private static class HiddenResourceTypedElement
    extends LocalResourceTypedElement {
        private final IFile realFile;

        public HiddenResourceTypedElement(IFile file, IFile realFile) {
            super((IResource)file);
            this.realFile = realFile;
        }

        public IFile getRealFile() {
            return this.realFile;
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class LocalResourceSaver
    implements EditableSharedDocumentAdapter.ISharedDocumentAdapterListener {
        LocalResourceTypedElement element;

        public LocalResourceSaver(LocalResourceTypedElement element) {
            this.element = element;
        }

        protected void save() throws CoreException {
            this.element.saveDocument(true, null);
            this.refreshIndexDiff();
        }

        private void refreshIndexDiff() {
            IResource resource = this.element.getResource();
            if (resource != null && HiddenResources.INSTANCE.isHiddenProject((IResource)resource.getProject())) {
                IndexDiffCacheEntry indexDiffCacheForRepository;
                String gitPath = null;
                Repository repository = null;
                URI uri = resource.getLocationURI();
                if ("file".equals(uri.getScheme())) {
                    Path location = new Path(uri.getSchemeSpecificPart());
                    repository = ResourceUtil.getRepository((IPath)location);
                    if (repository != null && (location = ResourceUtil.getRepositoryRelativePath((IPath)location, (Repository)repository)) != null) {
                        gitPath = location.toPortableString();
                    }
                } else {
                    repository = HiddenResources.INSTANCE.getRepository(uri);
                    if (repository != null) {
                        gitPath = HiddenResources.INSTANCE.getGitPath(uri);
                    }
                }
                if (gitPath != null && repository != null && (indexDiffCacheForRepository = IndexDiffCache.getInstance().getIndexDiffCacheEntry(repository)) != null) {
                    indexDiffCacheForRepository.refreshFiles(Collections.singletonList(gitPath));
                }
            }
        }

        public void handleDocumentConnected() {
        }

        public void handleDocumentDisconnected() {
        }

        public void handleDocumentFlushed() {
            try {
                this.save();
            }
            catch (CoreException e) {
                Activator.handleStatus(e.getStatus(), true);
            }
        }

        public void handleDocumentDeleted() {
        }

        public void handleDocumentSaved() {
        }
    }
}

