/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt.layout;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageLayout
extends StackLayout {
    private final Composite composite;
    private final Set<Control> pages = new LinkedHashSet<Control>();
    private final DisposeListener disposeListener = this::childDisposed;

    public PageLayout(Composite composite) {
        this.composite = composite;
        composite.setLayout((Layout)this);
    }

    public void showPage(Control control) {
        if (control.getParent() != this.composite) {
            throw new IllegalArgumentException("control is not in the composite");
        }
        if (this.topControl != control) {
            Control[] children = this.composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setVisible(children[i] == control);
                ++i;
            }
            if (this.pages.add(control)) {
                control.addDisposeListener(this.disposeListener);
            }
            this.topControl = control;
            this.composite.layout();
        }
    }

    public Control getCurrentPage() {
        return this.topControl;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control currentPage = this.topControl;
        if (currentPage == null) {
            currentPage = this.firstValidPage();
        }
        int width = 0;
        int height = 0;
        if (currentPage != null) {
            Point size = currentPage.computeSize(wHint, hHint, flushCache);
            width = size.x;
            height = size.y;
        }
        width += 2 * this.marginWidth;
        height += 2 * this.marginHeight;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    private Control firstValidPage() {
        Control[] children = this.composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control next = children[i];
            if (!next.isDisposed() && next != this.topControl) {
                return next;
            }
            ++i;
        }
        return null;
    }

    private void childDisposed(DisposeEvent event) {
        Control toShow;
        if (this.pages.remove(event.widget) && this.topControl == event.widget && !this.composite.isDisposed() && (toShow = this.firstValidPage()) != null) {
            this.showPage(toShow);
        }
    }
}

