/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.UntrackedFilesHandler;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.RestOfArgumentsHandler;

@Command(usage="usage_Status", common=true)
class Status
extends TextBuiltin {
    protected final String statusFileListFormat;
    protected final String statusFileListFormatWithPrefix;
    protected final String statusFileListFormatUnmerged;
    @Option(name="--porcelain", usage="usage_machineReadableOutput")
    protected boolean porcelain;
    @Option(name="--untracked-files", aliases={"-u", "-uno", "-uall"}, usage="usage_untrackedFilesMode", handler=UntrackedFilesHandler.class)
    protected String untrackedFilesMode;
    @Argument(required=false, index=0, metaVar="metaVar_paths")
    @Option(name="--", metaVar="metaVar_paths", handler=RestOfArgumentsHandler.class)
    protected List<String> filterPaths;

    Status() {
        this.statusFileListFormat = CLIText.get().statusFileListFormat;
        this.statusFileListFormatWithPrefix = CLIText.get().statusFileListFormatWithPrefix;
        this.statusFileListFormatUnmerged = CLIText.get().statusFileListFormatUnmerged;
        this.untrackedFilesMode = "all";
    }

    @Override
    protected void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(this.db);){
                StatusCommand statusCommand = git.status();
                if (this.filterPaths != null) {
                    for (String path : this.filterPaths) {
                        statusCommand.addPath(path);
                    }
                }
                org.eclipse.jgit.api.Status status = statusCommand.call();
                this.printStatus(status);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException | NoWorkTreeException e) {
            throw Status.die(e.getMessage(), e);
        }
    }

    private void printStatus(org.eclipse.jgit.api.Status status) throws IOException {
        if (this.porcelain) {
            this.printPorcelainStatus(status);
        } else {
            this.printLongStatus(status);
        }
    }

    private void printPorcelainStatus(org.eclipse.jgit.api.Status status) throws IOException {
        Set added = status.getAdded();
        Set changed = status.getChanged();
        Set removed = status.getRemoved();
        Set modified = status.getModified();
        Set missing = status.getMissing();
        Map conflicting = status.getConflictingStageState();
        TreeSet sorted = new TreeSet();
        sorted.addAll(added);
        sorted.addAll(changed);
        sorted.addAll(removed);
        sorted.addAll(modified);
        sorted.addAll(missing);
        sorted.addAll(conflicting.keySet());
        for (String path : sorted) {
            int x = 32;
            int y = 32;
            if (added.contains(path)) {
                x = 65;
            } else if (changed.contains(path)) {
                x = 77;
            } else if (removed.contains(path)) {
                x = 68;
            }
            if (modified.contains(path)) {
                y = 77;
            } else if (missing.contains(path)) {
                y = 68;
            }
            if (conflicting.containsKey(path)) {
                IndexDiff.StageState stageState = (IndexDiff.StageState)conflicting.get(path);
                switch (stageState) {
                    case BOTH_DELETED: {
                        x = 68;
                        y = 68;
                        break;
                    }
                    case ADDED_BY_US: {
                        x = 65;
                        y = 85;
                        break;
                    }
                    case DELETED_BY_THEM: {
                        x = 85;
                        y = 68;
                        break;
                    }
                    case ADDED_BY_THEM: {
                        x = 85;
                        y = 65;
                        break;
                    }
                    case DELETED_BY_US: {
                        x = 68;
                        y = 85;
                        break;
                    }
                    case BOTH_ADDED: {
                        x = 65;
                        y = 65;
                        break;
                    }
                    case BOTH_MODIFIED: {
                        x = 85;
                        y = 85;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown StageState: " + stageState);
                    }
                }
            }
            this.printPorcelainLine((char)x, (char)y, path);
        }
        if ("all".equals(this.untrackedFilesMode)) {
            TreeSet untracked = new TreeSet(status.getUntracked());
            for (String path : untracked) {
                this.printPorcelainLine('?', '?', path);
            }
        }
    }

    private void printPorcelainLine(char x, char y, String path) throws IOException {
        StringBuilder lineBuilder = new StringBuilder();
        lineBuilder.append(x).append(y).append(' ').append(path);
        this.outw.println(lineBuilder.toString());
    }

    private void printLongStatus(org.eclipse.jgit.api.Status status) throws IOException {
        int nbUntracked;
        int nbUnmerged;
        Ref head = this.db.exactRef("HEAD");
        if (head != null && head.isSymbolic()) {
            String branch = Repository.shortenRefName((String)head.getLeaf().getName());
            this.outw.println(CLIText.formatLine(MessageFormat.format(CLIText.get().onBranch, branch)));
        } else {
            this.outw.println(CLIText.formatLine(CLIText.get().notOnAnyBranch));
        }
        boolean firstHeader = true;
        Set added = status.getAdded();
        Set changed = status.getChanged();
        Set removed = status.getRemoved();
        Set modified = status.getModified();
        Set missing = status.getMissing();
        Set untracked = status.getUntracked();
        Map unmergedStates = status.getConflictingStageState();
        ArrayList<String> toBeCommitted = new ArrayList<String>(added);
        toBeCommitted.addAll(changed);
        toBeCommitted.addAll(removed);
        int nbToBeCommitted = toBeCommitted.size();
        if (nbToBeCommitted > 0) {
            this.printSectionHeader(CLIText.get().changesToBeCommitted, new Object[0]);
            this.printList(CLIText.get().statusNewFile, CLIText.get().statusModified, CLIText.get().statusRemoved, toBeCommitted, added, changed, removed);
            firstHeader = false;
        }
        ArrayList<String> notStagedForCommit = new ArrayList<String>(modified);
        notStagedForCommit.addAll(missing);
        int nbNotStagedForCommit = notStagedForCommit.size();
        if (nbNotStagedForCommit > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().changesNotStagedForCommit, new Object[0]);
            this.printList(CLIText.get().statusModified, CLIText.get().statusRemoved, null, notStagedForCommit, modified, missing, null);
            firstHeader = false;
        }
        if ((nbUnmerged = unmergedStates.size()) > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().unmergedPaths, new Object[0]);
            this.printUnmerged(unmergedStates);
            firstHeader = false;
        }
        if ((nbUntracked = untracked.size()) > 0 && "all".equals(this.untrackedFilesMode)) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().untrackedFiles, new Object[0]);
            this.printList(untracked);
        }
    }

    protected void printSectionHeader(String pattern, Object ... arguments) throws IOException {
        if (!this.porcelain) {
            this.outw.println(CLIText.formatLine(MessageFormat.format(pattern, arguments)));
            if (!pattern.isEmpty()) {
                this.outw.println(CLIText.formatLine(""));
            }
            this.outw.flush();
        }
    }

    protected int printList(Collection<String> list) throws IOException {
        if (!list.isEmpty()) {
            ArrayList<String> sortedList = new ArrayList<String>(list);
            Collections.sort(sortedList);
            for (String filename : sortedList) {
                this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormat, filename)));
            }
            this.outw.flush();
            return list.size();
        }
        return 0;
    }

    protected int printList(String status1, String status2, String status3, Collection<String> list, Collection<String> set1, Collection<String> set2, Collection<String> set3) throws IOException {
        ArrayList<String> sortedList = new ArrayList<String>(list);
        Collections.sort(sortedList);
        for (String filename : sortedList) {
            String prefix = set1.contains(filename) ? status1 : (set2.contains(filename) ? status2 : status3);
            this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormatWithPrefix, prefix, filename)));
            this.outw.flush();
        }
        return list.size();
    }

    private void printUnmerged(Map<String, IndexDiff.StageState> unmergedStates) throws IOException {
        ArrayList<String> paths = new ArrayList<String>(unmergedStates.keySet());
        Collections.sort(paths);
        for (String path : paths) {
            IndexDiff.StageState state = unmergedStates.get(path);
            String stateDescription = Status.getStageStateDescription(state);
            this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormatUnmerged, stateDescription, path)));
            this.outw.flush();
        }
    }

    private static String getStageStateDescription(IndexDiff.StageState stageState) {
        CLIText text = CLIText.get();
        switch (stageState) {
            case BOTH_DELETED: {
                return text.statusBothDeleted;
            }
            case ADDED_BY_US: {
                return text.statusAddedByUs;
            }
            case DELETED_BY_THEM: {
                return text.statusDeletedByThem;
            }
            case ADDED_BY_THEM: {
                return text.statusAddedByThem;
            }
            case DELETED_BY_US: {
                return text.statusDeletedByUs;
            }
            case BOTH_ADDED: {
                return text.statusBothAdded;
            }
            case BOTH_MODIFIED: {
                return text.statusBothModified;
            }
        }
        throw new IllegalArgumentException("Unknown StageState: " + stageState);
    }
}

