import { TextDocument, TextEdit, Position, Range } from 'vscode-languageserver-types';
import { FormatterSettings } from './main';
export declare class DockerFormatter {
    private getIndentation;
    /**
     * Creates a TextEdit for formatting the given document.
     *
     * @param document the document being formatted
     * @param start the start offset of the document's content to be replaced
     * @param end the end offset of the document's content to be replaced
     * @param indent true if this block should be replaced with an indentation, false otherwise
     * @param indentation the string to use for an indentation
     */
    private createFormattingEdit;
    formatOnType(document: TextDocument, position: Position, ch: string, options: FormatterSettings): TextEdit[];
    formatRange(document: TextDocument, range: Range, options: FormatterSettings): TextEdit[];
    formatDocument(document: TextDocument, options?: FormatterSettings): TextEdit[];
    /**
     * Formats the specified lines of the given document based on the
     * provided formatting options.
     *
     * @param document the text document to format
     * @param lines the lines to format
     * @param options the formatting options to use to perform the format
     * @return the text edits to apply to format the lines of the document
     */
    private format;
    private formatLines;
}
