/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.gist;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.GistFile;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.GistService;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubTaskDataHandler;
import org.eclipse.mylyn.internal.github.core.gist.GistAttribute;
import org.eclipse.mylyn.internal.github.core.gist.GistConnector;
import org.eclipse.mylyn.internal.github.core.gist.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class GistTaskDataHandler
extends GitHubTaskDataHandler {
    public static final int SUMMARY_LENGTH = 80;

    public TaskData fillComments(TaskRepository repository, TaskData data, List<Comment> comments) {
        this.addComments(data.getRoot(), comments, repository);
        return data;
    }

    public String getGistUrl(String repositoryUrl, Gist gist) {
        return String.valueOf(repositoryUrl) + '/' + gist.getId();
    }

    public TaskData fillTaskData(TaskRepository repository, TaskData data, Gist gist) {
        boolean isOwner = this.isOwner(repository, gist.getOwner());
        TaskAttributeMapper mapper = data.getAttributeMapper();
        TaskAttribute key = GistAttribute.KEY.getMetadata().create(data);
        mapper.setValue(key, gist.getId());
        TaskAttribute description = GistAttribute.DESCRIPTION.getMetadata().create(data);
        description.getMetaData().setReadOnly(!isOwner);
        String gistDescription = gist.getDescription();
        if (gistDescription != null) {
            mapper.setValue(description, gistDescription);
        }
        TaskAttribute created = GistAttribute.CREATED.getMetadata().create(data);
        mapper.setDateValue(created, gist.getCreatedAt());
        TaskAttribute updated = GistAttribute.UPDATED.getMetadata().create(data);
        mapper.setDateValue(updated, gist.getUpdatedAt());
        TaskAttribute url = GistAttribute.URL.getMetadata().create(data);
        url.setValue(gist.getHtmlUrl());
        TaskAttribute cloneUrl = GistAttribute.CLONE_URL.getMetadata().create(data);
        if (isOwner) {
            cloneUrl.setValue(gist.getGitPushUrl());
        } else {
            cloneUrl.setValue(gist.getGitPullUrl());
        }
        IRepositoryPerson reporterPerson = null;
        User owner = gist.getOwner();
        if (owner != null) {
            TaskAttribute reporter = GistAttribute.AUTHOR.getMetadata().create(data);
            reporterPerson = this.createPerson(owner, repository);
            mapper.setRepositoryPerson(reporter, reporterPerson);
            TaskAttribute gravatar = GistAttribute.AUTHOR_GRAVATAR.getMetadata().create(data);
            mapper.setValue(gravatar, owner.getAvatarUrl());
        }
        Map files = gist.getFiles();
        int fileCount = 0;
        long sizeCount = 0L;
        if (files != null && !files.isEmpty()) {
            int count = 1;
            for (GistFile file : files.values()) {
                ++fileCount;
                sizeCount += (long)file.getSize();
                TaskAttachmentMapper attachmentMapper = new TaskAttachmentMapper();
                attachmentMapper.setFileName(file.getFilename());
                attachmentMapper.setReplaceExisting(Boolean.TRUE);
                attachmentMapper.setLength(Long.valueOf(file.getSize()));
                attachmentMapper.setPatch(Boolean.FALSE);
                attachmentMapper.setAuthor(reporterPerson);
                attachmentMapper.setAttachmentId(file.getFilename());
                TaskAttribute attribute = data.getRoot().createAttribute("task.common.attachment-" + count);
                attachmentMapper.applyTo(attribute);
                GistAttribute.RAW_FILE_URL.getMetadata().create(attribute).setValue(file.getRawUrl());
                ++count;
            }
        }
        GistAttribute.COMMENT_NEW.getMetadata().create(data);
        TaskAttribute summary = GistAttribute.SUMMARY.getMetadata().create(data);
        mapper.setValue(summary, this.generateSummary(fileCount, sizeCount, gist.getDescription()));
        return data;
    }

    private String generateSummary(int files, long size, String description) {
        StringBuilder summaryText = new StringBuilder();
        if (description != null && !description.isEmpty()) {
            String desc = description.trim();
            int firstLine = desc.indexOf(10);
            if (firstLine != -1) {
                desc = desc.substring(0, firstLine).trim();
            }
            if (desc.length() > 80) {
                int lastWhitespace;
                desc = !Character.isWhitespace(desc.charAt(80)) && !Character.isWhitespace(desc.charAt(79)) ? ((lastWhitespace = desc.lastIndexOf(32)) > 0 ? desc.substring(0, lastWhitespace) : desc.substring(0, 80)) : desc.substring(0, 80);
                desc = desc.trim();
            }
            if (!desc.isEmpty()) {
                summaryText.append(description).append(' ');
            }
        }
        if (files != 1) {
            summaryText.append(MessageFormat.format(Messages.GistTaskDataHandler_FilesMultiple, files));
        } else {
            summaryText.append(Messages.GistTaskDataHandler_FilesSingle);
        }
        summaryText.append(',').append(' ').append(this.formatSize(size));
        return summaryText.toString();
    }

    private String formatSize(long size) {
        if (size == 1L) {
            return Messages.GistTaskDataHandler_SizeByte;
        }
        if (size < 1024L) {
            return new DecimalFormat(Messages.GistTaskDataHandler_SizeBytes).format(size);
        }
        if (size >= 1024L && size <= 1048575L) {
            return new DecimalFormat(Messages.GistTaskDataHandler_SizeKilobytes).format((double)size / 1024.0);
        }
        if (size >= 0x100000L && size <= 0x3FFFFFFFL) {
            return new DecimalFormat(Messages.GistTaskDataHandler_SizeMegabytes).format((double)size / 1048576.0);
        }
        return new DecimalFormat(Messages.GistTaskDataHandler_SizeGigabytes).format((double)size / 1.073741824E9);
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        RepositoryResponse response = null;
        Gist gist = new Gist();
        GitHubClient client = GistConnector.createClient(repository);
        AuthenticationCredentials credentials = repository.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            if (Boolean.parseBoolean(repository.getProperty(GitHub.PROPERTY_USE_TOKEN))) {
                client.setOAuth2Token(credentials.getPassword());
            } else {
                client.setCredentials(credentials.getUserName(), credentials.getPassword());
            }
            gist.setOwner(new User().setLogin(credentials.getUserName()));
        }
        GistService service = new GistService(client);
        TaskAttribute root = taskData.getRoot();
        gist.setId(taskData.getTaskId());
        gist.setDescription(root.getAttribute(GistAttribute.DESCRIPTION.getMetadata().getId()).getValue());
        if (taskData.isNew()) {
            try {
                gist = service.createGist(gist);
            }
            catch (IOException e) {
                throw new CoreException(GitHub.createWrappedStatus(e));
            }
            response = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, gist.getId());
        } else {
            try {
                String author;
                String newComment = root.getAttribute(GistAttribute.COMMENT_NEW.getMetadata().getId()).getValue();
                if (newComment.length() > 0) {
                    service.createComment(taskData.getTaskId(), newComment);
                }
                if (this.isOwner(repository, author = GistAttribute.AUTHOR.getMetadata().getValue(taskData))) {
                    service.updateGist(gist);
                }
            }
            catch (IOException e) {
                throw new CoreException(GitHub.createWrappedStatus(e));
            }
            response = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskData.getTaskId());
        }
        return response;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        TaskAttributeMapper mapper = data.getAttributeMapper();
        TaskAttribute summary = GistAttribute.SUMMARY.getMetadata().create(data);
        mapper.setValue(summary, Messages.GistTaskDataHandler_SummaryNewGist);
        GistAttribute.DESCRIPTION.getMetadata().create(data);
        return true;
    }

    protected boolean isOwner(TaskRepository repository, User author) {
        if (author == null) {
            return false;
        }
        return this.isOwner(repository, author.getLogin());
    }

    protected boolean isOwner(TaskRepository repository, String author) {
        AuthenticationCredentials creds = repository.getCredentials(AuthenticationType.REPOSITORY);
        if (creds == null) {
            return false;
        }
        return author != null && author.length() > 0 && author.equals(creds.getUserName());
    }
}

