/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl.mine;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionOrigin;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionPack;
import org.eclipse.passage.lic.internal.hc.i18n.MineMessages;
import org.eclipse.passage.lic.internal.hc.remote.RequestContext;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.internal.hc.remote.impl.Equipment;
import org.eclipse.passage.lic.internal.hc.remote.impl.ResultsTransfered;
import org.eclipse.passage.lic.internal.net.io.SafePayload;
import org.eclipse.passage.lic.licenses.model.api.FloatingServerConnection;

final class DecryptedConditions
implements ResponseHandler<Collection<ConditionPack>> {
    private final FloatingServerConnection coordinates;
    private final ConditionMiningTarget target;
    private final Equipment equipment;

    DecryptedConditions(Equipment equipment, FloatingServerConnection coordinates, ConditionMiningTarget target) {
        this.equipment = equipment;
        this.coordinates = coordinates;
        this.target = target;
    }

    @Override
    public Collection<ConditionPack> read(ResultsTransfered results, RequestContext context) throws LicensingException {
        byte[] safe = this.safeData(results, context);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(safe);){
                ConditionTransport.Data data = this.equipment.transport(results.contentType()).read((InputStream)stream);
                return Collections.singleton(new BaseConditionPack((ConditionOrigin)new BaseConditionOrigin(this.target, this.source(), data.signature()), data.conditions()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(MineMessages.DecryptedConditions_reading_error, (Throwable)e);
        }
    }

    private byte[] safeData(ResultsTransfered results, RequestContext context) throws LicensingException {
        return new SafePayload(this.equipment.keeper(context.product()), this.equipment.hash(context.hash())).decode(results.data());
    }

    private String source() {
        return String.format("%s:%d", this.coordinates.getIp(), this.coordinates.getPort());
    }
}

