/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.util;

import java.lang.reflect.Method;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.swt.widgets.Widget;

public class ObjectUtil {
    public static Object invokeMethod(Object object, String methodName) {
        return ObjectUtil.invokeMethod(object, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] argTypes, Object[] args) {
        Method method = ObjectUtil.getMethod(object, methodName, argTypes);
        Object result = object instanceof Widget ? ObjectUtil.invokeMethodUI(method, object, args) : ObjectUtil.invokeMethod(method, object, args);
        return result;
    }

    private static Method getMethod(Object object, String methodName, Class<?>[] argTypes) {
        Method method;
        try {
            method = object.getClass().getMethod(methodName, argTypes);
        }
        catch (Exception e) {
            throw new RedDeerException("Exception when retrieving method " + methodName + " by reflection", e);
        }
        return method;
    }

    private static Object invokeMethodUI(final Method method, final Object object, final Object[] args) {
        return Display.syncExec(new ResultRunnable<Object>(){

            @Override
            public Object run() {
                return ObjectUtil.invokeMethod(method, object, args);
            }
        });
    }

    private static Object invokeMethod(Method method, Object object, Object[] args) {
        try {
            return method.invoke(object, args);
        }
        catch (Exception e) {
            throw new RedDeerException("Exception when invoking method " + method + " by reflection", e);
        }
    }
}

