/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.LocalFileSaveable;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.LocalTypedElement;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.MergeInput;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.RemoteTypedElement;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;

public class MergeEditorInput
extends CompareEditorInput
implements ISaveablesSource,
IPropertyListener,
ICompareInputChangeListener {
    private LocalTypedElement left;
    private RemoteTypedElement right;
    private final IWorkbenchPage page;
    private final ListenerList inputChangeListeners = new ListenerList(1);
    private LocalFileSaveable saveable;

    public MergeEditorInput(LocalTypedElement left, RemoteTypedElement right, IWorkbenchPage page) {
        super(new CompareConfiguration());
        this.page = page;
        this.left = left;
        this.right = right;
        this.configureCompare();
    }

    protected void configureCompare() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(true);
        cc.setRightEditable(false);
        String name = TextProcessor.process((String)this.left.getName());
        String label = NLS.bind((String)Messages.MergeEditorInput_LocalFile, (Object)name);
        cc.setLeftLabel(label);
        name = TextProcessor.process((String)this.right.toString());
        label = NLS.bind((String)Messages.MergeEditorInput_RemoteFile, (Object)name);
        cc.setRightLabel(label);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MergeEditorInput) {
            MergeEditorInput other = (MergeEditorInput)((Object)obj);
            return other.left.equals(this.left) && other.right.equals((Object)this.right);
        }
        return false;
    }

    public int hashCode() {
        return this.left.hashCode() + this.right.hashCode();
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.right.cacheContents(monitor);
        MergeInput input = new MergeInput(this.left, this.right);
        this.setTitle(input.getName());
        return input;
    }

    public String getToolTipText() {
        return NLS.bind((String)Messages.MergeEditorInput_CompareLeftAndRight, (Object)this.left, (Object)((Object)this.right));
    }

    public String getTitle() {
        return NLS.bind((String)Messages.MergeEditorInput_CompareWithLocalCache, (Object)this.left.getName());
    }

    public MergeInput getCompareResult() {
        return (MergeInput)super.getCompareResult();
    }

    protected void handleDispose() {
        super.handleDispose();
        MergeInput compareInput = this.getCompareResult();
        if (compareInput != null) {
            compareInput.removeCompareInputChangeListener(this);
        }
        if (this.getCompareResult() != null) {
            this.getSaveable().removePropertyListener(this);
            this.getSaveable().dispose();
        }
        this.left.discardBuffer();
    }

    protected void contentsCreated() {
        super.contentsCreated();
        if (this.getCompareResult() != null) {
            this.getCompareResult().addCompareInputChangeListener(this);
            this.getSaveable().addPropertyListener(this);
            this.setDirty(this.getSaveable().isDirty());
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257 && this.getCompareResult() != null) {
            this.setDirty(this.getSaveable().isDirty());
        }
    }

    protected boolean closeEditor(boolean checkForUnsavedChanges) {
        if (this.isSaveNeeded() && checkForUnsavedChanges) {
            return false;
        }
        final IWorkbenchPage page = this.getPage();
        if (page == null) {
            return false;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell shell = page.getWorkbenchWindow().getShell();
                if (shell == null) {
                    return;
                }
                IEditorPart part = page.findEditor((IEditorInput)MergeEditorInput.this);
                MergeEditorInput.this.getPage().closeEditor(part, false);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Shell shell = page.getWorkbenchWindow().getShell();
            if (shell == null) {
                return false;
            }
            Display display = shell.getDisplay();
            display.asyncExec(runnable);
        }
        return true;
    }

    IWorkbenchPage getPage() {
        if (this.page == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return this.page;
    }

    void propogateInputChange() {
        if (!this.inputChangeListeners.isEmpty()) {
            Object[] allListeners = this.inputChangeListeners.getListeners();
            int i = 0;
            while (i < allListeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)allListeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void handleException(Throwable e) {
                    }

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)MergeEditorInput.this.getCompareResult());
                    }
                });
                ++i;
            }
        }
    }

    public LocalFileSaveable getSaveable() {
        if (this.saveable == null) {
            Assert.isNotNull((Object)this.getCompareResult());
            this.saveable = new LocalFileSaveable(this.getCompareResult(), this, this.left);
        }
        return this.saveable;
    }

    public Saveable[] getActiveSaveables() {
        if (this.getCompareResult() == null) {
            return new Saveable[0];
        }
        return new Saveable[]{this.getSaveable()};
    }

    public Saveable[] getSaveables() {
        return this.getActiveSaveables();
    }

    public void addCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.add((Object)listener);
        } else {
            super.addCompareInputChangeListener(input, listener);
        }
    }

    public void removeCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (input == this.getCompareResult()) {
            this.inputChangeListeners.remove((Object)listener);
        } else {
            super.removeCompareInputChangeListener(input, listener);
        }
    }

    public Image getTitleImage() {
        return UIPlugin.getImage("CompareEditor");
    }

    public ImageDescriptor getImageDescriptor() {
        return UIPlugin.getImageDescriptor("CompareEditor");
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier && this.getCompareResult() != null) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            dsp.addPropertyChangeListener((IPropertyChangeListener)this.getSaveable());
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener((IPropertyChangeListener)MergeEditorInput.this.getSaveable());
                }
            });
        }
        return newViewer;
    }

    public boolean canRunAsJob() {
        return true;
    }

    public boolean isDirty() {
        if (this.saveable != null) {
            return this.saveable.isDirty();
        }
        return super.isDirty();
    }

    public void compareInputChanged(ICompareInput source) {
        if (source == this.getCompareResult()) {
            boolean closed = false;
            if (source.getKind() == 0) {
                closed = this.closeEditor(true);
            }
            if (!closed) {
                this.propogateInputChange();
            }
        }
    }
}

