/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.PrintStream;
import java.util.HashMap;

public class Report {
    private static final String LEFT = "l";
    private static final String RIGHT = "r";
    private int fGap;
    private int fColumn;
    private int fRow;
    private int fRows;
    private HashMap<String, String> fContent = new HashMap();
    private HashMap<String, Integer> fWidths = new HashMap();
    private HashMap<String, String> fAlignment = new HashMap();

    public Report(int gap) {
        this.fGap = gap;
    }

    public void addCell(String value) {
        this.setCell(this.fColumn, this.fRow, value, LEFT);
        ++this.fColumn;
    }

    public void addCellRight(String value) {
        this.setCell(this.fColumn, this.fRow, value, RIGHT);
        ++this.fColumn;
    }

    public void nextRow() {
        ++this.fRow;
        this.fColumn = 0;
    }

    private void setCell(int x, int y, String value, String align) {
        this.fContent.put(String.valueOf(String.valueOf(x) + "/" + y), value);
        this.fAlignment.put(String.valueOf(String.valueOf(x) + "/" + y), align);
        Integer w = this.fWidths.get(Integer.toString(x));
        w = w == null ? Integer.valueOf(value.length()) : Integer.valueOf(Math.max(w, value.length()));
        this.fWidths.put(Integer.toString(x), w);
        this.fRows = Math.max(this.fRows, y + 1);
    }

    private String getCell(int x, int y) {
        return this.fContent.get(String.valueOf(x) + "/" + y);
    }

    public void print(PrintStream ps) {
        int n = this.fWidths.size();
        int y = 0;
        while (y < this.fRows) {
            int x = 0;
            while (x < n) {
                Integer w = this.fWidths.get(Integer.toString(x));
                int ww = w;
                String s = this.getCell(x, y);
                if (s == null) {
                    s = "";
                }
                if (x > 0) {
                    int g = 0;
                    while (g < this.fGap) {
                        ps.print(' ');
                        ++g;
                    }
                }
                int www = ww - s.length();
                String align = this.fAlignment.get(String.valueOf(x) + "/" + y);
                if (LEFT.equalsIgnoreCase(align)) {
                    ps.print(s);
                }
                int l = 0;
                while (l < www) {
                    ps.print(' ');
                    ++l;
                }
                if (RIGHT.equalsIgnoreCase(align)) {
                    ps.print(s);
                }
                ++x;
            }
            ps.println();
            ++y;
        }
    }
}

