/**
 * Copyright (c) 2010-2013, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 *   Csaba Debreceni - add exception for deprecated methods
 */
package org.eclipse.viatra.addon.viewers.runtime.notation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Item</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getPolicy <em>Policy</em>}</li>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamObject <em>Param Object</em>}</li>
 *   <li>{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamEObject <em>Param EObject</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getItem()
 * @model
 * @generated
 */
public interface Item extends FormattableElement {
	/**
	 * Returns the value of the '<em><b>Parent</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent</em>' reference.
	 * @see #setParent(Item)
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getItem_Parent()
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item#getChildren
	 * @model opposite="children"
	 * @generated
	 */
	Item getParent();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParent <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent</em>' reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(Item value);

	/**
	 * Returns the value of the '<em><b>Children</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.viatra.addon.viewers.runtime.notation.Item}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Children</em>' reference list.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getItem_Children()
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParent
	 * @model opposite="parent"
	 * @generated
	 */
	EList<Item> getChildren();

	/**
	 * Returns the value of the '<em><b>Policy</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Policy</em>' attribute.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy
	 * @see #setPolicy(HierarchyPolicy)
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getItem_Policy()
	 * @model
	 * @generated
	 */
	HierarchyPolicy getPolicy();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getPolicy <em>Policy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Policy</em>' attribute.
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy
	 * @see #getPolicy()
	 * @generated
	 */
	void setPolicy(HierarchyPolicy value);

	/**
	 * Returns the value of the '<em><b>Param Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Param Object</em>' attribute.
	 * @see #setParamObject(Object)
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getItem_ParamObject()
	 * @model
	 * @generated
	 */
	Object getParamObject();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamObject <em>Param Object</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Param Object</em>' attribute.
	 * @see #getParamObject()
	 * @generated
	 */
	void setParamObject(Object value);

	/**
	 * Returns the value of the '<em><b>Param EObject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Param EObject</em>' reference.
	 * @see #setParamEObject(EObject)
	 * @see org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage#getItem_ParamEObject()
	 * @model
	 * @generated
	 */
	EObject getParamEObject();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.addon.viewers.runtime.notation.Item#getParamEObject <em>Param EObject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Param EObject</em>' reference.
	 * @see #getParamEObject()
	 * @generated
	 */
	void setParamEObject(EObject value);

} // Item
