/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelElement;
import org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.TransformationModelElementLabelProvider;
import org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.properties.CrossReferenceElementPropertySource;
import org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.properties.CrossReferencePropertySource;

public class TransformationModelElementPropertySource
implements IPropertySource {
    private static final String IDENTIFIER_ID = "ID";
    private static final String ATTRIBUTE_ID = "Attributes";
    private static final String REFERENCE_ID = "References";
    private final TransformationModelElement element;

    public TransformationModelElementPropertySource(TransformationModelElement element) {
        this.element = element;
    }

    public Object getEditableValue() {
        return this.element;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList descriptors = Lists.newArrayList();
        PropertyDescriptor idDescriptor = new PropertyDescriptor((Object)IDENTIFIER_ID, IDENTIFIER_ID);
        idDescriptor.setCategory(ATTRIBUTE_ID);
        descriptors.add(idDescriptor);
        Map attributes = this.element.getAttributes();
        for (String attrName : attributes.keySet()) {
            if (attrName.equals("EObjectType")) continue;
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)attrName, attrName);
            descriptor.setCategory(ATTRIBUTE_ID);
            descriptors.add(descriptor);
        }
        Map crossReferences = this.element.getCrossReferences();
        for (String crossRefName : crossReferences.keySet()) {
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)crossRefName, crossRefName);
            descriptor.setLabelProvider((ILabelProvider)new TransformationModelElementLabelProvider());
            descriptor.setCategory(REFERENCE_ID);
            descriptors.add(descriptor);
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(IDENTIFIER_ID)) {
            return this.element.getId();
        }
        Map attributes = this.element.getAttributes();
        for (Map.Entry attr : attributes.entrySet()) {
            if (!((String)attr.getKey()).equals(id)) continue;
            return attr.getValue();
        }
        Map crossReferences = this.element.getCrossReferences();
        for (Map.Entry crossRef : crossReferences.entrySet()) {
            if (!((String)crossRef.getKey()).equals(id)) continue;
            List list = (List)crossRef.getValue();
            if (list.size() == 1) {
                return new CrossReferenceElementPropertySource((TransformationModelElement)list.get(0));
            }
            return new CrossReferencePropertySource(list);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

