/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.ui.AbstractSourceNewComposite;
import org.eclipse.wb.internal.core.utils.dialogfields.StatusUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class NewSourceDialog
extends TitleAreaDialog {
    private static final String USUAL_MESSAGE = Messages.NewSourceDialog_message;
    private static final String ONLY_ONE_SOURCE_MESSAGE = Messages.NewSourceDialog_messageOneSource;
    private final JavaInfo m_root;
    private boolean m_hasOneSource;
    private Group m_containerComposite;
    private StackLayout m_containerCompositeLayout;
    private Button m_okButton;
    private SourceDescription[] m_sourceDescriptions;
    private AbstractSourceNewComposite[] m_sourceComposites;
    private SourceDescription m_currentSourceDescription;
    private AbstractSourceNewComposite m_currentSourceComposite;
    private SourceViewer m_sampleViewer;
    private final PropertyChangeListener m_propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            NewSourceDialog.this.validateCurrentSourceComposite();
        }
    };
    private IEditableSource m_newEditableSource;
    private SourceDescription m_newSourceDescription;
    private Object m_newSourceParameters;

    public NewSourceDialog(Shell parentShell, JavaInfo root) {
        super(parentShell);
        this.m_root = root;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewSourceDialog_title);
        this.setMessage(USUAL_MESSAGE);
        this.setTitleImage(DesignerPlugin.getImage((String)"nls/add_source.gif"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        container.setLayout((Layout)new GridLayout());
        this.createTypeGroup(container);
        this.createPropertiesGroup(container);
        if (this.m_hasOneSource) {
            this.createContentsForOneSource();
        }
        return area;
    }

    private void createTypeGroup(final Composite container) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                NewSourceDialog.this.createDescriptionsControls(container);
            }
        });
        Group exampleGroup = new Group(container, 0);
        GridDataFactory.create((Control)exampleGroup).grabH().fillH();
        exampleGroup.setLayout((Layout)new GridLayout());
        exampleGroup.setText(Messages.NewSourceDialog_exampleGroup);
        this.m_sampleViewer = JdtUiUtils.createJavaSourceViewer((Composite)exampleGroup, 2048);
        GridDataFactory.create((Control)this.m_sampleViewer.getControl()).grab().fill().hintVC(4);
    }

    private void createDescriptionsControls(Composite container) throws Exception {
        this.m_sourceDescriptions = NlsSupport.getSourceDescriptions(this.m_root);
        this.m_sourceComposites = new AbstractSourceNewComposite[this.m_sourceDescriptions.length];
        boolean bl = this.m_hasOneSource = this.m_sourceDescriptions.length == 1;
        if (this.m_hasOneSource) {
            return;
        }
        Group typeGroup = new Group(container, 0);
        GridDataFactory.create((Control)typeGroup).grabH().fill();
        typeGroup.setLayout((Layout)new GridLayout());
        typeGroup.setText(Messages.NewSourceDialog_sourceTypesGroup);
        int i = 0;
        while (i < this.m_sourceDescriptions.length) {
            SourceDescription sourceDescription = this.m_sourceDescriptions[i];
            if (sourceDescription.getNewCompositeClass() != null) {
                String title = sourceDescription.getTitle();
                Button sourceButton = new Button((Composite)typeGroup, 16);
                sourceButton.setText(title);
                final int index = i;
                sourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                            public void run() throws Exception {
                                NewSourceDialog.this.populateForSourceIndex(index);
                            }
                        });
                    }
                });
            }
            ++i;
        }
    }

    private void createContentsForOneSource() {
        this.m_currentSourceDescription = this.m_sourceDescriptions[0];
        if (this.m_currentSourceDescription.getNewCompositeClass() == null) {
            return;
        }
        String title = this.m_currentSourceDescription.getTitle();
        this.setTitle(title);
        ExecutionUtils.runAsync((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                NewSourceDialog.this.populateForSourceIndex(0);
            }
        });
    }

    private void populateForSourceIndex(int index) throws Exception {
        this.m_currentSourceDescription = this.m_sourceDescriptions[index];
        this.m_currentSourceComposite = this.m_sourceComposites[index];
        if (this.m_currentSourceComposite == null) {
            this.m_currentSourceComposite = this.m_currentSourceDescription.createNewComposite((Composite)this.m_containerComposite, this.m_root);
            this.m_currentSourceComposite.addPropertyChangeListener(this.m_propertyChangeListener);
            this.m_sourceComposites[index] = this.m_currentSourceComposite;
        }
        this.m_containerCompositeLayout.topControl = this.m_currentSourceComposite;
        this.m_containerComposite.layout();
        if (this.m_sampleViewer != null) {
            String sample = this.m_currentSourceComposite.getSample();
            JdtUiUtils.setJavaSourceForViewer(this.m_sampleViewer, sample);
        }
        Point p = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(p.x, p.y);
        this.validateCurrentSourceComposite();
    }

    private void createPropertiesGroup(Composite parent) {
        this.m_containerComposite = new Group(parent, 0);
        GridDataFactory.create((Control)this.m_containerComposite).grab().fill();
        this.m_containerCompositeLayout = new StackLayout();
        this.m_containerComposite.setLayout((Layout)this.m_containerCompositeLayout);
        this.m_containerComposite.setText(Messages.NewSourceDialog_sourceProperties);
    }

    private void validateCurrentSourceComposite() {
        IStatus status = this.m_currentSourceComposite.getStatus();
        if (this.m_hasOneSource) {
            StatusUtils.applyToTitleAreaDialog((TitleAreaDialog)this, (IStatus)status, (String)ONLY_ONE_SOURCE_MESSAGE);
        } else {
            StatusUtils.applyToTitleAreaDialog((TitleAreaDialog)this, (IStatus)status, (String)USUAL_MESSAGE);
        }
        if (this.m_okButton != null) {
            this.m_okButton.setEnabled(status.getSeverity() < 4);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NewSourceDialog_shellTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.m_okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        try {
            this.m_newSourceDescription = this.m_currentSourceDescription;
            this.m_newSourceParameters = this.m_currentSourceComposite.createParametersObject();
            this.m_newEditableSource = this.m_currentSourceComposite.createEditableSource(this.m_newSourceParameters);
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
            return;
        }
        super.okPressed();
    }

    public IEditableSource getNewEditableSource() {
        return this.m_newEditableSource;
    }

    public SourceDescription getNewSourceDescription() {
        return this.m_newSourceDescription;
    }

    public Object getNewSourceParameters() {
        return this.m_newSourceParameters;
    }
}

