/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

public final class Version {
    private static final String SEPARATOR = ".";
    private final int m_major;
    private final int m_minor;
    private final int m_micro;

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int micro) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_micro = micro;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.m_major == other.m_major && this.m_minor == other.m_minor && this.m_micro == other.m_micro;
    }

    public int hashCode() {
        return this.m_minor + 37 * this.m_major + 37 * this.m_micro;
    }

    public String toString() {
        return this.getStringMajorMinorMicro();
    }

    public int getMajor() {
        return this.m_major;
    }

    public int getMinor() {
        return this.m_minor;
    }

    public int getMicro() {
        return this.m_micro;
    }

    public String getStringMajorMinor() {
        return String.valueOf(this.m_major) + SEPARATOR + this.m_minor;
    }

    public String getStringMajorMinorMicro() {
        return String.valueOf(this.m_major) + SEPARATOR + this.m_minor + SEPARATOR + this.m_micro;
    }

    public boolean isSame(Version that) {
        return this.equals(that);
    }

    public boolean isHigher(Version that) {
        if (this.m_major > that.m_major) {
            return true;
        }
        if (this.m_major == that.m_major) {
            if (this.m_minor > that.m_minor) {
                return true;
            }
            if (this.m_minor == that.m_minor) {
                return this.m_micro > that.m_micro;
            }
        }
        return false;
    }

    public boolean isHigherOrSame(Version that) {
        return this.isSame(that) || this.isHigher(that);
    }

    public boolean isLower(Version that) {
        if (this.m_major < that.m_major) {
            return true;
        }
        if (this.m_major == that.m_major) {
            if (this.m_minor < that.m_minor) {
                return true;
            }
            if (this.m_minor == that.m_minor) {
                return this.m_micro < that.m_micro;
            }
        }
        return false;
    }

    public boolean isLowerOrSame(Version that) {
        return this.isSame(that) || this.isLower(that);
    }
}

