/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.chrome;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractHTMLDebugDelegate;
import org.eclipse.wildwebdeveloper.debug.MessageUtils;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.chrome.ChromeExecutableTab;

public class ChromeRunDAPDebugDelegate
extends AbstractHTMLDebugDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.chromeRunDebug";
    static final String VERBOSE = "verbose";
    private static final String TRACE = "trace";
    public static final String RUNTIME_EXECUTABLE = "runtimeExecutable";
    public static final String URL = "url";
    private static final String SOURCE_MAPS = "sourceMaps";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File executable;
        String url;
        Map env;
        Object[] args;
        HashMap<String, Object> param = new HashMap<String, Object>();
        String argsString = configuration.getAttribute("runtimeArgs", "").trim();
        if (!argsString.isEmpty() && (args = Arrays.asList(argsString.split(" ")).stream().filter(s -> !s.trim().isEmpty()).toArray()).length > 0) {
            param.put("runtimeArgs", args);
        }
        if (!(env = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.emptyMap())).isEmpty()) {
            JsonObject envJson = new JsonObject();
            env.forEach((arg_0, arg_1) -> ((JsonObject)envJson).addProperty(arg_0, arg_1));
            param.put(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envJson);
        }
        if (!(url = configuration.getAttribute(URL, "")).equals("")) {
            param.put(URL, url);
        } else {
            param.put("file", configuration.getAttribute("program", "no program path defined"));
        }
        String cwd = configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "").trim();
        if (!cwd.isEmpty()) {
            param.put("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", cwd);
        }
        param.put(SOURCE_MAPS, true);
        String chromeLocation = ChromeRunDAPDebugDelegate.findChromeLocation(configuration);
        File file = executable = chromeLocation != null && !chromeLocation.isBlank() ? new File(chromeLocation) : null;
        if (executable == null || !executable.isAbsolute() || !executable.canExecute()) {
            MessageUtils.showBrowserLocationsConfigurationError(Activator.getShell(), configuration, mode, Messages.RuntimeExecutable_Chrome, true);
            return;
        }
        param.put(RUNTIME_EXECUTABLE, chromeLocation);
        if (configuration.getAttribute(VERBOSE, false)) {
            param.put(TRACE, VERBOSE);
        }
        super.launchWithParameters(configuration, mode, launch, monitor, param, ChromeRunDAPDebugDelegate.findDebugAdapter());
    }

    static File findDebugAdapter() {
        try {
            URL fileURL = FileLocator.toFileURL((URL)ChromeRunDAPDebugDelegate.class.getResource("/node_modules/debugger-for-chrome/out/src/chromeDebug.js"));
            return new File(fileURL.toURI());
        }
        catch (IOException | URISyntaxException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(() -> ChromeRunDAPDebugDelegate.lambda$2(e, (IStatus)errorStatus));
            return null;
        }
    }

    static String findChromeLocation(ILaunchConfiguration configuration) {
        String res = "";
        try {
            res = configuration.getAttribute(RUNTIME_EXECUTABLE, res);
        }
        catch (CoreException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
        }
        File executable = new File(res);
        if (executable.isAbsolute() && executable.canExecute()) {
            return res;
        }
        return BrowserManager.getInstance().getWebBrowsers().stream().filter(ChromeExecutableTab::isChrome).findAny().map(IBrowserDescriptor::getLocation).orElse(null);
    }

    private static /* synthetic */ void lambda$2(Exception exception, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)exception.getMessage(), (IStatus)iStatus);
    }
}

