/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core;

import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.internal.schema.SchemaProcessorRegistryReader;
import org.eclipse.wst.json.core.internal.schema.catalog.CatalogSet;
import org.eclipse.wst.json.core.schema.catalog.ICatalog;
import org.osgi.framework.BundleContext;

public class JSONCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.json.core";
    public static final String USER_CATALOG_ID = "user_catalog";
    public static final String DEFAULT_CATALOG_ID = "default_catalog";
    public static final String SYSTEM_CATALOG_ID = "system_catalog";
    private CatalogSet catalogSet = null;
    private String defaultCatalogFileStateLocation;
    private static JSONCorePlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JSONCorePlugin getDefault() {
        return plugin;
    }

    private String getPluginStateLocation(String fileName) {
        String location = this.getStateLocation().append(fileName).toString();
        String file_protocol = "file:";
        if (location != null && !location.startsWith(file_protocol)) {
            location = String.valueOf(file_protocol) + location;
        }
        return location;
    }

    public IJSONSchemaDocument getSchemaDocument(IJSONNode node) throws IOException {
        return SchemaProcessorRegistryReader.getInstance().getSchemaDocument(node.getModel());
    }

    public ICatalog getDefaultJSONCatalog() {
        if (this.catalogSet == null) {
            this.catalogSet = new CatalogSet();
            this.defaultCatalogFileStateLocation = this.getPluginStateLocation("default_catalog.xml");
            this.catalogSet.putCatalogPersistenceLocation(DEFAULT_CATALOG_ID, this.defaultCatalogFileStateLocation);
            this.catalogSet.putCatalogPersistenceLocation(SYSTEM_CATALOG_ID, this.getPluginStateLocation("system_catalog.xml"));
            this.catalogSet.putCatalogPersistenceLocation(USER_CATALOG_ID, this.getPluginStateLocation("user_catalog.xml"));
        }
        return this.catalogSet.lookupOrCreateCatalog(DEFAULT_CATALOG_ID, this.defaultCatalogFileStateLocation);
    }

    public void clearCatalogCache() {
        if (this.catalogSet != null) {
            this.catalogSet.clearResourceCache();
        }
    }
}

