/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TristateCheckboxFieldEditor
extends BooleanFieldEditor {
    private List<TristateCheckboxFieldEditor> fields = null;
    private Composite parent;
    private int value = 0;
    private int oldValue = 0;
    private SelectionListener selectionListener = null;

    public TristateCheckboxFieldEditor(String name, String label, Composite parent) {
        super(name, label, parent);
        this.parent = parent;
    }

    public Button getCheckbox() {
        return this.getChangeControl(this.parent);
    }

    protected List<TristateCheckboxFieldEditor> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<TristateCheckboxFieldEditor>();
        }
        return this.fields;
    }

    public void addField(final TristateCheckboxFieldEditor field) {
        this.getFields().add(field);
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int newValue;
                    int n = newValue = TristateCheckboxFieldEditor.this.getCheckbox().getSelection() ? 1 : 0;
                    if (TristateCheckboxFieldEditor.this.getCheckbox().getGrayed()) {
                        newValue = 2;
                    }
                    TristateCheckboxFieldEditor.this.valueChanged(TristateCheckboxFieldEditor.this.oldValue, newValue);
                    TristateCheckboxFieldEditor.this.oldValue = newValue;
                    for (TristateCheckboxFieldEditor field : TristateCheckboxFieldEditor.this.fields) {
                        field.setValue(newValue);
                    }
                    TristateCheckboxFieldEditor.this.updateCheckState();
                }
            };
            this.getCheckbox().addSelectionListener(this.selectionListener);
        }
        field.getCheckbox().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newValue = TristateCheckboxFieldEditor.this.getCheckbox().getSelection() ? 2 : 0;
                TristateCheckboxFieldEditor.this.valueChanged(field.oldValue, newValue);
                field.oldValue = newValue;
                if (field.fields != null) {
                    for (TristateCheckboxFieldEditor f : field.fields) {
                        f.setValue(newValue);
                    }
                }
                TristateCheckboxFieldEditor.this.updateCheckState();
            }
        });
    }

    protected void doLoad() {
        if (this.getCheckbox() != null) {
            if (this.fields == null) {
                super.doLoad();
            } else {
                int value = this.getPreferenceStore().getInt(this.getPreferenceName());
                this.setValue(value);
                this.oldValue = value;
            }
        }
    }

    protected void doLoadDefault() {
        if (this.getCheckbox() != null) {
            if (this.fields == null) {
                super.doLoad();
            } else {
                int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
                this.setValue(value);
                this.oldValue = value;
            }
        }
    }

    protected void doStore() {
        if (this.fields == null) {
            super.doStore();
        } else {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.getValue());
        }
    }

    protected void setValue(int newValue) {
        if (this.fields == null) {
            this.getCheckbox().setSelection(newValue != 0);
        } else {
            int oldValue = this.value;
            if (newValue == 0) {
                this.getCheckbox().setSelection(false);
                this.getCheckbox().setGrayed(false);
                this.value = 0;
            } else if (newValue == 1) {
                this.getCheckbox().setSelection(true);
                this.getCheckbox().setGrayed(true);
                this.value = 1;
            } else if (newValue == 2) {
                this.getCheckbox().setSelection(true);
                this.getCheckbox().setGrayed(false);
                this.value = 2;
            }
            this.valueChanged(oldValue, newValue);
        }
    }

    protected void valueChanged(int oldValue, int newValue) {
        if (this.fields == null) {
            super.valueChanged(oldValue != 0, newValue != 0);
        } else {
            this.setPresentsDefaultValue(false);
            if (oldValue != newValue) {
                this.fireValueChanged("field_editor_value", oldValue, newValue);
                this.value = newValue;
            }
        }
    }

    public void updateCheckState() {
        int trueCount = 0;
        for (TristateCheckboxFieldEditor field : this.fields) {
            if (!field.getBooleanValue()) continue;
            ++trueCount;
        }
        if (trueCount == this.fields.size()) {
            this.setValue(2);
        } else if (trueCount == 0) {
            this.setValue(0);
        } else {
            this.setValue(1);
        }
    }

    public int getValue() {
        return this.value;
    }
}

