/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.Checkers;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public class LaunchModesPropertyPage
extends FieldEditorPreferencePage {
    private final List<FieldEditor> editors;
    private final boolean runInEditor;

    public LaunchModesPropertyPage(IProblem problem, PreferenceStore prefStore) {
        super(1);
        CheckersRegistry registry = CheckersRegistry.getInstance();
        IChecker checker = registry.getCheckerForProblem(problem);
        this.runInEditor = checker != null ? Checkers.canCheckerRunAsYouType((IChecker)checker) : false;
        this.setPreferenceStore((IPreferenceStore)prefStore);
        this.editors = new ArrayList<FieldEditor>();
    }

    public void noDefaultAndApplyButton() {
        super.noDefaultAndApplyButton();
    }

    protected void createFieldEditors() {
        if (this.runInEditor) {
            this.addEditor(CheckerLaunchMode.RUN_AS_YOU_TYPE, CodanUIMessages.LaunchModesPropertyPage_RunAsYouType);
        }
        this.addEditor(CheckerLaunchMode.RUN_ON_FILE_OPEN, CodanUIMessages.LaunchModesPropertyPage_RunOnFileOpen);
        this.addEditor(CheckerLaunchMode.RUN_ON_FILE_SAVE, CodanUIMessages.LaunchModesPropertyPage_RunOnFileSave);
        this.addEditor(CheckerLaunchMode.RUN_ON_INC_BUILD, CodanUIMessages.LaunchModesPropertyPage_RunOnIncrementalBuild);
        this.addEditor(CheckerLaunchMode.RUN_ON_FULL_BUILD, CodanUIMessages.LaunchModesPropertyPage_RunOnFullBuild);
        this.addEditor(CheckerLaunchMode.RUN_ON_DEMAND, CodanUIMessages.LaunchModesPropertyPage_RunOnDemand);
    }

    private void addEditor(CheckerLaunchMode launchMode, String label) {
        this.addField((FieldEditor)new BooleanFieldEditor(launchMode.name(), label, this.getFieldEditorParent()));
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        return result;
    }
}

