/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cdt.meson.ui.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class SWTImagesFactory {
    private static ImageRegistry imageRegistry = Activator.getPlugin().getImageRegistry();
    private static URL fgIconBaseURL;
    private static final String NAME_PREFIX = "org.eclipse.cdt.meson.ui.";
    private static final int NAME_PREFIX_LENGTH;
    public static final String IMG_MESON = "org.eclipse.cdt.meson.ui.meson-logo.png";
    public static final ImageDescriptor DESC_MESON;

    static {
        try {
            fgIconBaseURL = new URL(Activator.getPlugin().getBundle().getEntry("/"), "icons/");
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        NAME_PREFIX_LENGTH = NAME_PREFIX.length();
        DESC_MESON = SWTImagesFactory.createManaged("", IMG_MESON);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        return SWTImagesFactory.createManaged(imageRegistry, prefix, name);
    }

    private static ImageDescriptor createManaged(ImageRegistry registry, String prefix, String name) {
        ImageDescriptor result = ImageDescriptor.createFromURL((URL)SWTImagesFactory.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
        registry.put(name, result);
        return result;
    }

    public static Image get(String key) {
        return imageRegistry.get(key);
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)SWTImagesFactory.makeIconFileURL(prefix, name));
    }

    private static URL makeIconFileURL(String prefix, String name) {
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(name);
        try {
            return new URL(fgIconBaseURL, buffer.toString());
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return null;
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        if (relPath.startsWith(NAME_PREFIX)) {
            relPath = relPath.substring(NAME_PREFIX_LENGTH);
        }
        action.setDisabledImageDescriptor(SWTImagesFactory.create("d" + type, relPath));
        action.setImageDescriptor(SWTImagesFactory.create("e" + type, relPath));
    }

    static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }
}

