/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CompareOutlinePage
extends Page
implements IContentOutlinePage,
IPropertyChangeListener {
    private CompareEditor fCompareEditor;
    private Control fControl;
    private CompareViewerSwitchingPane fStructurePane;
    private OutlineViewerCreator fCreator;

    CompareOutlinePage(CompareEditor editor) {
        this.fCompareEditor = editor;
    }

    public void createControl(Composite parent) {
        Splitter h = new Splitter(parent, 256);
        this.fStructurePane = new CompareViewerSwitchingPane((Composite)h, 0x800800, true){

            @Override
            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareOutlinePage.this.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        h.setVisible((Control)this.fStructurePane, true);
        this.fControl = h;
        IPageSite site = this.getSite();
        site.setSelectionProvider((ISelectionProvider)this.fStructurePane);
        h.layout();
        this.reset();
    }

    private Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        OutlineViewerCreator creator = this.getCreator();
        if (creator != null) {
            return creator.findStructureViewer(oldViewer, input, parent, this.getCompareConfiguration());
        }
        return null;
    }

    private CompareConfiguration getCompareConfiguration() {
        return this.fCompareEditor.getCompareConfiguration();
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setFocus() {
        if (this.fStructurePane != null) {
            this.fStructurePane.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fStructurePane != null) {
            this.fStructurePane.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.fStructurePane != null) {
            return this.fStructurePane.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fStructurePane != null) {
            this.fStructurePane.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fStructurePane != null) {
            this.fStructurePane.setSelection(selection);
        }
    }

    private void setInput(Object input) {
        if (this.fStructurePane != null) {
            this.fStructurePane.setInput(input);
            ((Splitter)this.fControl).layout();
        }
    }

    public OutlineViewerCreator getCreator() {
        if (this.fCreator == null) {
            this.fCreator = (OutlineViewerCreator)Adapters.adapt((Object)((Object)this.fCompareEditor), OutlineViewerCreator.class);
            if (this.fCreator != null) {
                this.fCreator.addPropertyChangeListener(this);
            }
        }
        return this.fCreator;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.compare.OutlineInput")) {
            this.fStructurePane.setInput(event.getNewValue());
            ((Splitter)this.fControl).layout();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fCreator != null) {
            this.fCreator.removePropertyChangeListener(this);
        }
        this.fCreator = null;
    }

    public void reset() {
        if (this.fCreator != null) {
            this.fCreator.removePropertyChangeListener(this);
        }
        this.fCreator = null;
        OutlineViewerCreator creator = this.getCreator();
        if (creator != null) {
            this.setInput(creator.getInput());
        } else {
            this.setInput(null);
        }
    }
}

