/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.manifest.SupportedDataSetType;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.AndExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.NotExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.OrExpression;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationFactory;

public class ExtensionContributor
implements IContributor {
    public static final String ELEMENT_NAME = "contributor";
    public static final String SUB_ELEMENT_FILTER_EXPRESSION_TYPE = "supportedOdaFilterExpression";
    public static final String ATTR_ODA_FILTER_EXPR_NAME = "name";
    public static final String ATTR_VALIDATOR_CLASS = "validatorClass";
    public static final String ATTR_SPEC_FACTORY_CLASS = "specificationFactoryClass";
    public static final String SUB_ELEMENT_ROW_ORDERING_SUPPORT = "supportsRowOrdering";
    public static final String ATTR_NULL_ORDERING_SUPPORT = "nullValueOrdering";
    public static final String ATTR_NESTED_VALUEEXPR_SUPPORT = "supportsNestedExpressions";
    public static final String SUB_ELEMENT_COMBINE_QUERIES_SUPPORT = "supportsCombiningQueries";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private IConfigurationElement m_contributorElement;
    private List<SupportedDataSetType> m_dataSetTypes;
    private List<String> m_supportedOdaFilterExprNames;
    private IValidator m_validator;
    private QuerySpecificationFactory m_specFactory;
    private boolean m_supportsRowOrdering;
    private boolean m_supportsNullOrdering;
    private boolean m_supportsNestedValueExprs;
    private boolean m_supportsCombineQueries;

    public ExtensionContributor(IConfigurationElement contributorElement) throws OdaException {
        this.init(contributorElement);
    }

    private void init(IConfigurationElement contributorElement) throws OdaException {
        this.m_contributorElement = contributorElement;
        if (!this.m_contributorElement.isValid() || this.getDeclaringExtensionId() == null) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_EXT_POINT_ELEMENT, (Object)"org.eclipse.datatools.connectivity.oda.dynamicResultSet", (Object)contributorElement.getContributor().getName()));
        }
        this.m_dataSetTypes = ExtensionContributor.processDataSetTypeElements(this.m_contributorElement);
        this.m_supportsRowOrdering = false;
        this.m_supportsNullOrdering = false;
        IConfigurationElement[] rowOrderingElements = contributorElement.getChildren(SUB_ELEMENT_ROW_ORDERING_SUPPORT);
        if (rowOrderingElements.length > 0) {
            this.m_supportsRowOrdering = true;
            String attrValue = rowOrderingElements[0].getAttribute(ATTR_NULL_ORDERING_SUPPORT);
            if (attrValue != null) {
                this.m_supportsNullOrdering = Boolean.parseBoolean(attrValue);
            }
        }
        this.m_supportsCombineQueries = false;
        IConfigurationElement[] combineQueriesElements = contributorElement.getChildren(SUB_ELEMENT_COMBINE_QUERIES_SUPPORT);
        if (combineQueriesElements.length > 0) {
            this.m_supportsCombineQueries = true;
        }
    }

    void setSupportedOdaFilterExpressions(IConfigurationElement element) throws OdaException {
        this.m_supportedOdaFilterExprNames = ExtensionContributor.processSupportedOdaFilterExpressions(element);
    }

    public static List<SupportedDataSetType> processDataSetTypeElements(IConfigurationElement contributorElement) throws OdaException {
        IConfigurationElement[] dataSetTypeElements = contributorElement.getChildren("supportedDataSetType");
        if (dataSetTypeElements.length == 0) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_MISSING_EXT_POINT_MIN_ELEMENT, (Object[])new Object[]{"org.eclipse.datatools.connectivity.oda.dynamicResultSet", contributorElement.getDeclaringExtension().getUniqueIdentifier(), "supportedDataSetType"}));
        }
        ArrayList<SupportedDataSetType> dataSetTypes = new ArrayList<SupportedDataSetType>(dataSetTypeElements.length);
        int i = 0;
        while (i < dataSetTypeElements.length) {
            dataSetTypes.add(new SupportedDataSetType(dataSetTypeElements[i]));
            ++i;
        }
        return dataSetTypes;
    }

    private static List<String> processSupportedOdaFilterExpressions(IConfigurationElement element) throws OdaException {
        IConfigurationElement[] odaExprElements = element.getChildren(SUB_ELEMENT_FILTER_EXPRESSION_TYPE);
        if (odaExprElements.length == 0) {
            return null;
        }
        ArrayList<String> odaExprNames = new ArrayList<String>(odaExprElements.length);
        int i = 0;
        while (i < odaExprElements.length) {
            String exprName = odaExprElements[i].getAttribute(ATTR_ODA_FILTER_EXPR_NAME);
            if (exprName != null && (exprName.equalsIgnoreCase(AndExpression.class.getSimpleName()) || exprName.equalsIgnoreCase(OrExpression.class.getSimpleName()) || exprName.equalsIgnoreCase(NotExpression.class.getSimpleName())) && !odaExprNames.contains(exprName)) {
                odaExprNames.add(exprName);
            }
            ++i;
        }
        return odaExprNames;
    }

    void processSupportedValueExpressionType(IConfigurationElement valueExprGroupElement) {
        this.m_supportsNestedValueExprs = false;
        String attrValue = valueExprGroupElement.getAttribute(ATTR_NESTED_VALUEEXPR_SUPPORT);
        if (attrValue != null) {
            this.m_supportsNestedValueExprs = Boolean.parseBoolean(attrValue);
        }
    }

    public String getDeclaringExtensionId() {
        return this.m_contributorElement.getDeclaringExtension().getUniqueIdentifier();
    }

    public String getName() {
        return this.m_contributorElement.getContributor().getName();
    }

    public boolean supportsDataSetType(String odaDataSourceId, String odaDataSetId) {
        int i = 0;
        while (i < this.m_dataSetTypes.size()) {
            SupportedDataSetType dataSetType = this.m_dataSetTypes.get(i);
            if (dataSetType.matches(odaDataSourceId, odaDataSetId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean supportsDataSetType(SupportedDataSetType dataSetType) {
        if (dataSetType == null) {
            return false;
        }
        return this.supportsDataSetType(dataSetType.getOdaDataSourceId(), dataSetType.getOdaDataSetId());
    }

    public SupportedDataSetType[] getSupportedDataSetTypes() {
        return this.m_dataSetTypes.toArray(new SupportedDataSetType[this.m_dataSetTypes.size()]);
    }

    public boolean supportsOdaFilterExpression(String odaExprName) {
        if (this.m_supportedOdaFilterExprNames == null) {
            return false;
        }
        return this.m_supportedOdaFilterExprNames.contains(odaExprName);
    }

    public String[] getSupportedOdaFilterExpressions() {
        if (this.m_supportedOdaFilterExprNames == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.m_supportedOdaFilterExprNames.toArray(new String[this.m_supportedOdaFilterExprNames.size()]);
    }

    public boolean supportsDynamicRowOrdering() {
        return this.m_supportsRowOrdering;
    }

    public boolean supportsDynamicCombiningQueries() {
        return this.m_supportsCombineQueries;
    }

    public boolean supportsNullValueOrdering() {
        return this.supportsDynamicRowOrdering() && this.m_supportsNullOrdering;
    }

    public boolean supportsOdaCombinedOperator(String builtInOperatorId) {
        return ResultExtensionExplorer.getInstance().supportsOdaCombinedOperator(this.getDeclaringExtensionId(), builtInOperatorId);
    }

    public boolean supportsCombinedValueExpressionType() {
        return ResultExtensionExplorer.getInstance().supportsCombinedValueExpressionType(this.getDeclaringExtensionId());
    }

    public boolean supportsNestedValueExpressionType() {
        return this.m_supportsNestedValueExprs;
    }

    public boolean supportsFunctionValueExpressionType() {
        return ResultExtensionExplorer.getInstance().supportsFunctionValueExpressionType(this.getDeclaringExtensionId());
    }

    public IValidator getValidator() throws OdaException {
        if (this.m_validator == null) {
            String validatorClassName = this.m_contributorElement.getAttribute(ATTR_VALIDATOR_CLASS);
            if (validatorClassName == null || validatorClassName.length() == 0) {
                return null;
            }
            try {
                Object validatorClass = this.m_contributorElement.createExecutableExtension(ATTR_VALIDATOR_CLASS);
                if (!(validatorClass instanceof IValidator)) {
                    throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_CLASS_TYPE_ATTRIBUTE, (Object[])new Object[]{validatorClassName, ATTR_VALIDATOR_CLASS, IValidator.class.getName()}));
                }
                this.m_validator = (IValidator)validatorClass;
            }
            catch (CoreException ex) {
                throw new OdaException(ex);
            }
        }
        return this.m_validator;
    }

    public QuerySpecificationFactory getSpecificationFactory() throws OdaException {
        if (this.m_specFactory == null) {
            String factoryClassName = this.m_contributorElement.getAttribute(ATTR_SPEC_FACTORY_CLASS);
            if (factoryClassName == null || factoryClassName.length() == 0) {
                return null;
            }
            try {
                Object factoryClass = this.m_contributorElement.createExecutableExtension(ATTR_SPEC_FACTORY_CLASS);
                if (!(factoryClass instanceof QuerySpecificationFactory)) {
                    throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_CLASS_TYPE_ATTRIBUTE, (Object[])new Object[]{factoryClassName, ATTR_SPEC_FACTORY_CLASS, QuerySpecificationFactory.class.getName()}));
                }
                this.m_specFactory = (QuerySpecificationFactory)factoryClass;
            }
            catch (CoreException ex) {
                throw new OdaException(ex);
            }
        }
        return this.m_specFactory;
    }

    public int hashCode() {
        return this.m_contributorElement.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExtensionContributor)) {
            return false;
        }
        return this.m_contributorElement.equals((Object)((ExtensionContributor)obj).m_contributorElement);
    }
}

