/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.internal.theme;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;

@Component
public class ThemeEngineManager
implements IThemeManager {
    private static final String KEY = "org.eclipse.e4.ui.css.swt.theme";
    private static ILog LOG = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.e4.ui.css.swt.theme"));

    @Override
    public IThemeEngine getEngineForDisplay(Display display) {
        IThemeEngine engine = (IThemeEngine)display.getData(KEY);
        if (engine == null) {
            engine = new ThemeEngine(display);
            engine.addCSSEngine(this.getCSSSWTEngine(display));
            display.setData(KEY, (Object)engine);
        }
        return engine;
    }

    private CSSEngine getCSSSWTEngine(Display display) {
        CSSEngine cssEngine = WidgetElement.getEngine((Display)display);
        if (cssEngine != null) {
            return cssEngine;
        }
        cssEngine = new CSSSWTEngineImpl(display, true);
        cssEngine.setErrorHandler(e -> ThemeEngineManager.logError(e.getMessage(), e));
        WidgetElement.setEngine((Display)display, (CSSEngine)cssEngine);
        return cssEngine;
    }

    static void logError(String message, Throwable e) {
        LOG.log((IStatus)new Status(4, KEY, message, e));
    }
}

