/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteserviceadmin.ui.rsa;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.remoteservices.ui.Activator;
import org.eclipse.ecf.internal.remoteservices.ui.DiscoveryComponent;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteservice.ui.services.IServicesView;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRSAContentProvider;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRSANode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ExportRegistrationNode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ImportRegistrationNode;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.ServiceReference;

public abstract class AbstractRemoteServiceAdminView
extends ViewPart {
    protected TreeViewer viewer;
    protected AbstractRSAContentProvider contentProvider;

    protected RemoteServiceAdmin getLocalRSA() {
        DiscoveryComponent discovery = DiscoveryComponent.getDefault();
        return discovery == null ? null : discovery.getRSA();
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void makeActions() {
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractRemoteServiceAdminView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected AbstractRSANode getSelectedNode() {
        return (AbstractRSANode)((ITreeSelection)this.viewer.getSelection()).getFirstElement();
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
        this.contentProvider = null;
    }

    protected abstract AbstractRSAContentProvider createContentProvider(IViewSite var1);

    protected void updateModel() {
    }

    protected void setupListeners() {
    }

    protected void setupSelectionListeners() {
        final String servicesViewId = Activator.getDefault().getLocalServicesViewId();
        if (servicesViewId != null) {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection sel = event.getSelection();
                    Object selection = null;
                    if (sel instanceof IStructuredSelection) {
                        selection = ((IStructuredSelection)sel).getFirstElement();
                    }
                    ServiceReference sr = null;
                    if (selection instanceof ExportRegistrationNode) {
                        sr = ((ExportRegistrationNode)selection).getServiceReference();
                    } else if (selection instanceof ImportRegistrationNode) {
                        sr = ((ImportRegistrationNode)selection).getServiceReference();
                    }
                    if (sr != null) {
                        AbstractRemoteServiceAdminView.this.selectServiceInServicesView(servicesViewId, (Long)sr.getProperty("service.id"));
                    }
                }
            });
        }
    }

    protected void selectServiceInServicesView(String servicesViewId, long serviceId) {
        try {
            IViewPart view = this.findView(servicesViewId);
            if (view != null) {
                if (view instanceof IServicesView) {
                    IServicesView sv = (IServicesView)view;
                    sv.selectService(null, serviceId);
                } else {
                    this.logWarning("Could not select services on viewId=" + servicesViewId, null);
                }
            }
        }
        catch (Exception e) {
            this.logWarning("Could not show services in PDE Plugin view", e);
        }
    }

    protected void log(int level, String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(level, "org.eclipse.ecf.remoteservice.ui", message, e));
    }

    protected void logWarning(String message, Throwable e) {
        this.log(2, message, e);
    }

    protected void logError(String message, Throwable e) {
        this.log(4, message, e);
    }

    public void createPartControl(Composite parent) {
        IViewSite viewSite = this.getViewSite();
        this.contentProvider = this.createContentProvider(viewSite);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)viewSite);
        this.makeActions();
        this.hookContextMenu();
        viewSite.setSelectionProvider((ISelectionProvider)this.viewer);
        this.setupListeners();
        this.setupSelectionListeners();
        RemoteServiceAdmin rsa = this.getLocalRSA();
        if (rsa != null) {
            this.updateModel();
        }
    }

    protected IViewPart findView(String viewId) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.findView(viewId);
        }
        return null;
    }

    public void setFocus() {
    }
}

