/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.security.CDOPermissionProvider;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public abstract class CDOServerIndication
extends IndicationWithResponse {
    public CDOServerIndication(CDOServerProtocol protocol, short signalID) {
        super((SignalProtocol)protocol, signalID);
    }

    public CDOServerProtocol getProtocol() {
        return (CDOServerProtocol)super.getProtocol();
    }

    protected InternalSession getSession() {
        return this.getProtocol().getSession();
    }

    protected InternalRepository getRepository() {
        InternalRepository repository = this.getSession().getRepository();
        if (!LifecycleUtil.isActive((Object)repository)) {
            throw new IllegalStateException("CDORepositoryInfo has been deactivated");
        }
        return repository;
    }

    protected IStore getStore() {
        InternalStore store = this.getRepository().getStore();
        if (!LifecycleUtil.isActive((Object)store)) {
            throw new IllegalStateException("Store has been deactivated");
        }
        return store;
    }

    protected InternalView getView(int viewID) {
        InternalSession session = this.getSession();
        return session.getView(viewID);
    }

    protected String getAdditionalInfo() {
        String additionalInfo = super.getAdditionalInfo();
        String userID = this.getSession().getUserID();
        if (userID != null) {
            additionalInfo = String.valueOf(additionalInfo) + ", user=" + userID;
        }
        return additionalInfo;
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        this.indicating((CDODataInput)new CDODataInputImpl((ExtendedDataInput)in){

            public CDOPackageRegistry getPackageRegistry() {
                return CDOServerIndication.this.getRepository().getPackageRegistry();
            }

            protected boolean isXCompression() {
                return CDOProtocolConstants.X_COMPRESSION;
            }

            protected StringIO getPackageURICompressor() {
                return CDOServerIndication.this.getProtocol().getPackageURICompressor();
            }

            protected CDOBranchManager getBranchManager() {
                return CDOServerIndication.this.getRepository().getBranchManager();
            }

            protected CDOCommitInfoManager getCommitInfoManager() {
                return CDOServerIndication.this.getRepository().getCommitInfoManager();
            }

            protected CDORevisionFactory getRevisionFactory() {
                return CDOServerIndication.this.getRepository().getRevisionManager().getFactory();
            }

            protected CDOLobStore getLobStore() {
                return null;
            }

            protected CDOListFactory getListFactory() {
                return CDOListFactory.DEFAULT;
            }
        });
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        this.responding((CDODataOutput)new CDODataOutputImpl((ExtendedDataOutput)out){

            public CDOPackageRegistry getPackageRegistry() {
                return CDOServerIndication.this.getRepository().getPackageRegistry();
            }

            public CDORevisionUnchunker getRevisionUnchunker() {
                return CDOServerIndication.this.getRepository();
            }

            public CDOIDProvider getIDProvider() {
                return CDOServerIndication.this.getSession();
            }

            public CDOPermissionProvider getPermissionProvider() {
                return CDOServerIndication.this.getSession();
            }

            protected boolean isXCompression() {
                return CDOProtocolConstants.X_COMPRESSION;
            }

            protected StringIO getPackageURICompressor() {
                return CDOServerIndication.this.getProtocol().getPackageURICompressor();
            }
        });
    }

    protected abstract void indicating(CDODataInput var1) throws IOException;

    protected abstract void responding(CDODataOutput var1) throws IOException;
}

