/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.remote.core;

import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetProvider;
import org.eclipse.launchbar.core.target.TargetStatus;
import org.eclipse.launchbar.remote.core.internal.Activator;
import org.eclipse.launchbar.remote.core.internal.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;

public abstract class RemoteLaunchTargetProvider
implements ILaunchTargetProvider,
IRemoteConnectionChangeListener {
    private static final TargetStatus CLOSED = new TargetStatus(TargetStatus.Code.ERROR, Messages.RemoteLaunchTargetProvider_Closed);
    private ILaunchTargetManager targetManager;

    protected abstract String getTypeId();

    protected void initLaunchTarget(ILaunchTarget target) {
    }

    public void init(ILaunchTargetManager targetManager) {
        this.targetManager = targetManager;
        String typeId = this.getTypeId();
        IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
        ILaunchTarget[] iLaunchTargetArray = targetManager.getLaunchTargetsOfType(typeId);
        int n = iLaunchTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchTarget target = iLaunchTargetArray[n2];
            IRemoteConnection connection = (IRemoteConnection)target.getAdapter(IRemoteConnection.class);
            if (connection == null) {
                targetManager.removeLaunchTarget(target);
            }
            ++n2;
        }
        IRemoteConnectionType remoteType = remoteManager.getConnectionType(typeId);
        for (IRemoteConnection remote : remoteType.getConnections()) {
            String id = remote.getName();
            if (targetManager.getLaunchTarget(typeId, id) != null) continue;
            this.initLaunchTarget(targetManager.addLaunchTarget(typeId, id));
        }
        remoteManager.addRemoteConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    public TargetStatus getStatus(ILaunchTarget target) {
        IRemoteConnection connection = (IRemoteConnection)target.getAdapter(IRemoteConnection.class);
        if (connection != null) {
            if (connection.isOpen()) {
                return TargetStatus.OK_STATUS;
            }
            return CLOSED;
        }
        return new TargetStatus(TargetStatus.Code.ERROR, Messages.RemoteLaunchTargetProvider_Missing);
    }

    public void connectionChanged(RemoteConnectionChangeEvent event) {
        IRemoteConnection connection = event.getConnection();
        if (connection.getConnectionType().getId().equals(this.getTypeId())) {
            switch (event.getType()) {
                case 16: {
                    this.initLaunchTarget(this.targetManager.addLaunchTarget(this.getTypeId(), connection.getName()));
                    break;
                }
                case 32: {
                    ILaunchTarget target = this.targetManager.getLaunchTarget(this.getTypeId(), connection.getName());
                    if (target == null) break;
                    this.targetManager.removeLaunchTarget(target);
                    break;
                }
                case 8: {
                    if (!(connection instanceof IRemoteConnectionWorkingCopy)) break;
                    IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)connection;
                    IRemoteConnection original = ((IRemoteConnectionWorkingCopy)connection).getOriginal();
                    ILaunchTarget target = this.targetManager.getLaunchTarget(this.getTypeId(), original.getName());
                    if (target != null) {
                        this.targetManager.removeLaunchTarget(target);
                    }
                    this.initLaunchTarget(this.targetManager.addLaunchTarget(this.getTypeId(), wc.getName()));
                }
            }
        }
    }
}

