/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import org.eclipse.mat.hprof.ChunkedGZIPRandomAccessFile;
import org.eclipse.mat.hprof.GZIPInputStream2;
import org.eclipse.mat.hprof.SeekableStream;

class CompressedRandomAccessFile
extends RandomAccessFile {
    SeekableStream ss;

    public CompressedRandomAccessFile(File file, final boolean random, long length) throws IOException {
        super(file, "r");
        final FileChannel ch = this.getChannel();
        long len = ch.size();
        long decompSize = 65536L;
        int cacheSize = (int)Math.min(Math.min(len / 100000L, 1000L) + len / 1000000L, 1000000L);
        long required = (long)cacheSize * decompSize * 4L;
        long maxFree = CompressedRandomAccessFile.checkMemSpace(required);
        if (required > maxFree) {
            cacheSize = (int)(maxFree / decompSize / 4L);
        }
        this.ss = new SeekableStream(new Supplier<InputStream>(){

            @Override
            public InputStream get() {
                try {
                    FilterInputStream is = new FilterInputStream(Channels.newInputStream(ch)){
                        long mark_pos;

                        @Override
                        public boolean markSupported() {
                            return true;
                        }

                        @Override
                        public void mark(int n) {
                            try {
                                this.mark_pos = ch.position();
                            }
                            catch (IOException e) {
                                this.mark_pos = -1L;
                            }
                        }

                        @Override
                        public void reset() throws IOException {
                            ch.position(this.mark_pos);
                        }
                    };
                    SeekableStream.UnclosableInputStream is2 = new SeekableStream.UnclosableInputStream(is);
                    return random ? new GZIPInputStream2(is2) : new GZIPInputStream(is2);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }, ch, cacheSize, length);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.ss.seek(pos);
    }

    @Override
    public long getFilePointer() {
        return this.ss.position();
    }

    @Override
    public long length() {
        return Long.MAX_VALUE;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.ss.read(buf);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.ss.read(buf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.ss.close();
        super.close();
    }

    public static long estimatedLength(File f) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RandomAccessFile ra = new RandomAccessFile(f, "r");){
            return CompressedRandomAccessFile.estimatedLength(ra);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static long estimateWork(File f) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RandomAccessFile ra = new RandomAccessFile(f, "r");){
            if (ChunkedGZIPRandomAccessFile.isChunkedGZIPFile(ra)) {
                return f.length();
            }
            return CompressedRandomAccessFile.estimatedLength(ra);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static long estimatedLength(RandomAccessFile ra) throws IOException {
        if (ChunkedGZIPRandomAccessFile.isChunkedGZIPFile(ra)) {
            return Long.MAX_VALUE;
        }
        long filel = ra.length();
        long pos = ra.getFilePointer();
        try {
            boolean gzip = CompressedRandomAccessFile.isGZIP(ra);
            if (gzip) {
                ra.seek(filel - 4L);
                int r1 = ra.read();
                int r2 = ra.read();
                int r3 = ra.read();
                int r4 = ra.read();
                long len32 = ((long)(r4 & 0xFF) << 24) + (long)((r3 & 0xFF) << 16) + (long)((r2 & 0xFF) << 8) + (long)(r1 & 0xFF);
                long estimate = (long)((double)filel * 5.0);
                long e1 = (estimate & 0xFFFFFFFF00000000L) + len32;
                long e2 = e1 + 0x100000000L;
                long e3 = e1 - 0x100000000L;
                long best = e1;
                if (Math.abs(e2 - estimate) < Math.abs(best - estimate)) {
                    best = e2;
                }
                if (e3 >= 0L && Math.abs(e3 - estimate) < Math.abs(best - estimate)) {
                    best = e3;
                }
                if (len32 <= filel || len32 <= 0x100000L) {
                    best = Long.MAX_VALUE;
                }
                long l = best;
                return l;
            }
            long l = filel;
            return l;
        }
        finally {
            ra.seek(pos);
        }
    }

    static boolean isGZIP(RandomAccessFile ra) throws IOException {
        long pos = ra.getFilePointer();
        try {
            boolean gzip;
            if (pos != 0L) {
                ra.seek(0L);
            }
            int b1 = ra.read();
            int b2 = ra.read();
            int b3 = ra.read();
            boolean bl = gzip = b1 == 31 && b2 == 139 && b3 == 8;
            return bl;
        }
        finally {
            ra.seek(pos);
        }
    }

    static long checkMemSpace(long requested) {
        Runtime runtime = Runtime.getRuntime();
        long maxFree = runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
        if (maxFree < requested) {
            runtime.gc();
            maxFree = runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
            return maxFree;
        }
        return maxFree;
    }
}

