/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.SerializableFileInfo;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class FetchInfoCommand
extends AbstractCommand<IFileInfo> {
    private final DataOutputStream out;
    private final DataInputStream in;
    private final String path;

    public FetchInfoCommand(ProxyConnection conn, String path) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
        this.path = path;
    }

    @Override
    public IFileInfo call() throws ProxyException {
        try {
            StreamChannel chan = this.openChannel();
            this.out.writeByte(1);
            this.out.writeShort(107);
            this.out.writeByte(chan.getId());
            this.out.writeUTF(this.path);
            this.out.flush();
            byte res = this.in.readByte();
            if (res != 0) {
                String errMsg = this.in.readUTF();
                throw new ProxyException(errMsg);
            }
            DataInputStream resultStream = new DataInputStream(chan.getInputStream());
            SerializableFileInfo info = new SerializableFileInfo();
            info.readObject(resultStream);
            chan.close();
            return info.getIFileInfo();
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
    }
}

