/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.trace;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.ctf.core.trace.IPacketReader;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.LostEventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderDefinition;

@NonNullByDefault
public final class CTFPacketReader
implements IPacketReader,
IDefinitionScope {
    private static final IDefinitionScope EVENT_HEADER_SCOPE = new IDefinitionScope(){

        @Override
        public @Nullable IDefinition lookupDefinition(@Nullable String lookupPath) {
            return null;
        }

        @Override
        public @Nullable ILexicalScope getScopePath() {
            return null;
        }
    };
    private final BitBuffer fInput;
    private final ICTFPacketDescriptor fPacketContext;
    private final List<@Nullable IEventDeclaration> fDeclarations;
    private boolean fHasLost;
    private long fLastTimestamp;
    private final @Nullable IDeclaration fStreamEventHeaderDecl;
    private final @Nullable StructDeclaration fStreamContext;
    private final @Nullable ICompositeDefinition fTracePacketHeader;
    private final @Nullable IDefinitionScope fPacketScope;
    private @Nullable ICompositeDefinition fEventHeader;
    private long fPosition;

    public CTFPacketReader(BitBuffer input, ICTFPacketDescriptor packetContext, List<@Nullable IEventDeclaration> declarations, @Nullable IDeclaration eventHeaderDeclaration, @Nullable StructDeclaration streamContext, @Nullable ICompositeDefinition packetHeader, IDefinitionScope packetScope) {
        this.fInput = input;
        this.fPosition = packetContext.getPayloadStartBits();
        this.fPacketContext = packetContext;
        this.fDeclarations = declarations;
        this.fPacketScope = packetScope;
        this.fHasLost = this.fPacketContext.getLostEvents() != 0L;
        this.fLastTimestamp = this.fPacketContext.getTimestampBegin();
        this.fStreamEventHeaderDecl = eventHeaderDeclaration;
        this.fStreamContext = streamContext;
        this.fTracePacketHeader = packetHeader;
    }

    @Override
    public int getCPU() {
        return (int)this.fPacketContext.getTargetId();
    }

    @Override
    public boolean hasMoreEvents() {
        return this.fHasLost || this.fInput.position() < this.fPacketContext.getContentSizeBits();
    }

    @Override
    public EventDefinition readNextEvent() throws CTFException {
        int eventID = -2;
        long posStart = this.fInput.position();
        if (this.fHasLost && posStart >= this.fPacketContext.getContentSizeBits()) {
            this.fHasLost = false;
            return this.createLostEvent(this.fPacketContext);
        }
        this.fEventHeader = null;
        IDeclaration streamEventHeaderDecl = this.fStreamEventHeaderDecl;
        if (streamEventHeaderDecl instanceof IEventHeaderDeclaration) {
            IEventHeaderDeclaration eventHeaderDeclaration = (IEventHeaderDeclaration)streamEventHeaderDecl;
            EventHeaderDefinition ehd = (EventHeaderDefinition)eventHeaderDeclaration.createDefinition(EVENT_HEADER_SCOPE, "", this.fInput);
            this.fEventHeader = ehd;
            eventID = ehd.getId();
        } else if (streamEventHeaderDecl instanceof StructDeclaration) {
            StructDefinition variantCurrentField;
            Definition vIdDef;
            StructDefinition structEventHeaderDef = ((StructDeclaration)streamEventHeaderDecl).createDefinition(EVENT_HEADER_SCOPE, ILexicalScope.EVENT_HEADER, this.fInput);
            this.fEventHeader = structEventHeaderDef;
            Definition idDef = structEventHeaderDef.lookupDefinition("id");
            SimpleDatatypeDefinition simpleIdDef = null;
            if (idDef instanceof SimpleDatatypeDefinition) {
                simpleIdDef = (SimpleDatatypeDefinition)idDef;
            } else if (idDef != null) {
                throw new CTFIOException("Id defintion not an integer, enum or float definiton in event header.");
            }
            Definition variantDef = structEventHeaderDef.lookupDefinition("v");
            if (variantDef instanceof VariantDefinition && (vIdDef = (variantCurrentField = (StructDefinition)((VariantDefinition)variantDef).getCurrentField()).lookupDefinition("id")) instanceof IntegerDefinition) {
                simpleIdDef = (SimpleDatatypeDefinition)vIdDef;
            }
            if (simpleIdDef != null) {
                eventID = simpleIdDef.getIntegerValue().intValue();
            }
        }
        if ((long)eventID == -2L && this.fDeclarations.size() == 1) {
            eventID = 0;
        }
        if (eventID < 0 || eventID >= this.fDeclarations.size()) {
            throw new CTFIOException("Invalid event id : " + eventID + " File position : " + posStart / 8L + '/' + this.fPacketContext.getContentSizeBits() / 8L);
        }
        IEventDeclaration eventDeclaration = this.fDeclarations.get(eventID);
        if (!(eventDeclaration instanceof EventDeclaration)) {
            throw new CTFIOException("Invalid event id : " + eventID);
        }
        EventDeclaration declaration = (EventDeclaration)eventDeclaration;
        EventDefinition eventDef = declaration.createDefinition(this.fStreamContext, this.fPacketContext, this.fTracePacketHeader, this.fEventHeader, this.fInput, this.fLastTimestamp);
        this.fLastTimestamp = eventDef.getTimestamp();
        if (posStart == this.fInput.position()) {
            throw new CTFIOException("Empty event not allowed, event: " + eventDef.getDeclaration().getName());
        }
        this.fPosition = posStart;
        return eventDef;
    }

    private EventDefinition createLostEvent(ICTFPacketDescriptor currentPacket) {
        LostEventDeclaration lostEventDeclaration = LostEventDeclaration.INSTANCE;
        StructDeclaration lostFields = lostEventDeclaration.getFields();
        IntegerDeclaration lostFieldsDecl = (IntegerDeclaration)lostFields.getField("Lost events");
        if (lostFieldsDecl == null) {
            throw new IllegalStateException("Lost events count not declared!");
        }
        IntegerDeclaration lostEventsDurationDecl = (IntegerDeclaration)lostFields.getField("duration");
        if (lostEventsDurationDecl == null) {
            throw new IllegalStateException("Lost events duration not declared!");
        }
        long lostEventsTimestamp = this.fLastTimestamp;
        long lostEventsDuration = currentPacket.getTimestampEnd() - lostEventsTimestamp;
        IntegerDefinition lostDurationDef = new IntegerDefinition(lostFieldsDecl, null, "duration", lostEventsDuration);
        IntegerDefinition lostCountDef = new IntegerDefinition(lostEventsDurationDecl, null, "Lost events", this.fPacketContext.getLostEvents());
        Definition[] fields = new IntegerDefinition[]{lostCountDef, lostDurationDef};
        int cpu = (int)this.fPacketContext.getTargetId();
        return new EventDefinition(lostEventDeclaration, cpu, lostEventsTimestamp, null, null, null, null, new StructDefinition(lostFields, (IDefinitionScope)this, "fields", fields), this.fPacketContext);
    }

    @Override
    public ILexicalScope getScopePath() {
        return ILexicalScope.PACKET;
    }

    @Override
    public @Nullable IDefinition lookupDefinition(@Nullable String lookupPath) {
        if (ILexicalScope.TRACE_PACKET_HEADER.getPath().equals(lookupPath)) {
            return this.fTracePacketHeader;
        }
        if (ILexicalScope.STREAM_PACKET_CONTEXT.getPath().equals(lookupPath) && this.fPacketScope != null) {
            return this.fPacketScope.lookupDefinition(lookupPath);
        }
        return null;
    }

    @Override
    public ICTFPacketDescriptor getCurrentPacket() {
        return this.fPacketContext;
    }

    public long getLocation() {
        return this.fPosition;
    }

    @Override
    public @Nullable ICompositeDefinition getCurrentPacketEventHeader() {
        return this.fEventHeader;
    }

    public @Nullable ICompositeDefinition getTracePacketHeader() {
        return this.fTracePacketHeader;
    }
}

