/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.document.JSONException;
import org.eclipse.wst.json.core.internal.document.JSONStructureImpl;
import org.eclipse.wst.json.core.internal.document.JSONValueImpl;

public class JSONArrayImpl
extends JSONStructureImpl
implements IJSONArray {
    public JSONArrayImpl() {
    }

    public JSONArrayImpl(JSONArrayImpl object) {
        super(object);
    }

    @Override
    public IJSONNode cloneNode(boolean deep) {
        JSONArrayImpl cloned = new JSONArrayImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return "array";
    }

    @Override
    public String getNodeValue() throws JSONException {
        return null;
    }

    @Override
    public IJSONArray add(IJSONValue value) {
        if (value == null || value.getOwnerPairNode() != null) {
            return null;
        }
        JSONValueImpl attr = (JSONValueImpl)value;
        attr.setOwnerPairNode(this.getOwnerPairNode());
        attr.setParentNode(this);
        this.notifyChildReplaced(value, null);
        return this;
    }

    @Override
    public IJSONArray remove(IJSONValue value) {
        if (value == null || value.getOwnerPairNode() != null) {
            return null;
        }
        this.notifyChildReplaced(null, value);
        return this;
    }

    @Override
    public String getSimpleValue() {
        return null;
    }

    @Override
    public String getValueRegionType() {
        return null;
    }
}

