/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class XSLTSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ArrayList<DirectorySourceContainer> containers = new ArrayList<DirectorySourceContainer>();
        String sourceFileExpr = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null);
        IPath sourceFile = XSLTSourcePathComputerDelegate.getSubstitutedPath(sourceFileExpr);
        LaunchPipeline pipeline = XSLTSourcePathComputerDelegate.hydratePipeline(configuration);
        containers.add(new DirectorySourceContainer(sourceFile, false));
        for (LaunchTransform transform : pipeline.getTransformDefs()) {
            IPath path = transform.getPath();
            DirectorySourceContainer sourceContainer = null;
            if (transform.getPathType().equals("resource")) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                IContainer container = resource.getParent();
                if (container.getType() == 4) {
                    sourceContainer = new ProjectSourceContainer((IProject)container, false);
                } else if (container.getType() == 2) {
                    sourceContainer = new FolderSourceContainer(container, false);
                }
            } else {
                sourceContainer = new DirectorySourceContainer(path, false);
            }
            containers.add(sourceContainer);
        }
        return containers.toArray(new ISourceContainer[0]);
    }

    private static LaunchPipeline hydratePipeline(ILaunchConfiguration configuration) throws CoreException {
        LaunchPipeline pipeline = null;
        String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PIPELINE", null);
        if (s != null && s.length() > 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
            pipeline = LaunchPipeline.fromXML(inputStream);
        }
        return pipeline;
    }

    private static IPath getSubstitutedPath(String path) throws CoreException {
        if (path != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            return new Path(path);
        }
        return null;
    }
}

