/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.preferences.addon;

import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.BundleDefaultsScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceSpyAddon {
    @Inject
    private Logger LOG;
    @Inject
    private IEventBroker eventBroker;
    private IEclipsePreferences bundleDefaultsScopePreferences = BundleDefaultsScope.INSTANCE.getNode("");
    private IEclipsePreferences configurationScopePreferences = ConfigurationScope.INSTANCE.getNode("");
    private IEclipsePreferences defaultScopePreferences = DefaultScope.INSTANCE.getNode("");
    private IEclipsePreferences instanceScopePreferences = InstanceScope.INSTANCE.getNode("");
    private ChangedPreferenceListener preferenceChangedListener = new ChangedPreferenceListener();

    @Inject
    @Optional
    public void initialzePreferenceSpy(@Preference(value="tracepreferences") boolean tracePreferences) {
        if (tracePreferences) {
            this.registerVisitors();
        } else {
            this.deregisterVisitors();
        }
    }

    private void registerVisitors() {
        this.addPreferenceListener(this.bundleDefaultsScopePreferences);
        this.addPreferenceListener(this.configurationScopePreferences);
        this.addPreferenceListener(this.defaultScopePreferences);
        this.addPreferenceListener(this.instanceScopePreferences);
    }

    private void addPreferenceListener(IEclipsePreferences rootPreference) {
        try {
            rootPreference.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)PreferenceSpyAddon.this.preferenceChangedListener);
                    return true;
                }
            });
        }
        catch (BackingStoreException e) {
            this.LOG.error((Throwable)e);
        }
    }

    private void deregisterVisitors() {
        this.removePreferenceListener(this.bundleDefaultsScopePreferences);
        this.removePreferenceListener(this.configurationScopePreferences);
        this.removePreferenceListener(this.defaultScopePreferences);
        this.removePreferenceListener(this.instanceScopePreferences);
    }

    private void removePreferenceListener(IEclipsePreferences rootPreference) {
        try {
            rootPreference.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)PreferenceSpyAddon.this.preferenceChangedListener);
                    return true;
                }
            });
        }
        catch (BackingStoreException e) {
            this.LOG.error((Throwable)e);
        }
    }

    private final class ChangedPreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private ChangedPreferenceListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PreferenceSpyAddon.this.eventBroker.post("TOPIC_PREFERENCESPY/PREFERENCE/CHANGED", (Object)event);
        }
    }
}

