/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.TreeSet;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ConfigurationLogUpdateSection
implements ISystemSummarySection {
    private void writeInstalledIUs(PrintWriter writer) {
        ServiceCaller.callOnce(this.getClass(), IProfileRegistry.class, registry -> {
            IProfile profile = registry.getProfile("_SELF_");
            if (profile == null) {
                return;
            }
            writer.println(IDEWorkbenchMessages.ConfigurationLogUpdateSection_installConfiguration);
            writer.println(" " + NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_lastChangedOn, (Object)DateFormat.getDateInstance().format(new Date(profile.getTimestamp()))));
            writer.println(" " + NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_location, (Object)profile.getProperty("org.eclipse.equinox.p2.installFolder")));
            writer.println(" " + NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_timestamp, (Object)Long.toString(profile.getTimestamp())));
            writer.println();
            TreeSet<String> sorted = new TreeSet<String>();
            for (IInstallableUnit unit : profile.available(QueryUtil.createIUAnyQuery(), null)) {
                sorted.add(NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_IU, (Object)unit.getId(), (Object)unit.getVersion()));
            }
            if (!sorted.isEmpty()) {
                writer.println(IDEWorkbenchMessages.ConfigurationLogUpdateSection_IUHeader);
                writer.println();
                for (String string : sorted) {
                    writer.println(string);
                }
            }
        });
    }

    private void writeBundles(PrintWriter writer) {
        ServiceCaller.callOnce(this.getClass(), PlatformAdmin.class, admin -> {
            State state = admin.getState(false);
            TreeSet<String> sorted = new TreeSet<String>();
            BundleDescription[] bundleDescriptionArray = state.getBundles();
            int n = bundleDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundle = bundleDescriptionArray[n2];
                String name = bundle.getName();
                if (name == null) {
                    name = bundle.getLocation();
                }
                String message = NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_bundle, (Object[])new Object[]{name, bundle.getVersion(), bundle.getLocation()});
                sorted.add(message);
                ++n2;
            }
            if (!sorted.isEmpty()) {
                writer.println(IDEWorkbenchMessages.ConfigurationLogUpdateSection_bundleHeader);
                writer.println();
                for (String string : sorted) {
                    writer.println(string);
                }
            }
        });
    }

    public void write(PrintWriter writer) {
        this.writeInstalledIUs(writer);
        writer.println();
        this.writeBundles(writer);
    }
}

