/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.wst.wsdl.validation.internal.ControllerValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.IWSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.exception.ValidateWSDLException;
import org.eclipse.wst.wsdl.validation.internal.logging.LoggerFactory;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.xml.AbstractXMLConformanceFactory;
import org.eclipse.wst.wsdl.validation.internal.xml.DefaultXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.LineNumberDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ValidationController {
    protected final String _ERROR_PROBLEM_WSDL_VALIDATOR = "_ERROR_PROBLEM_WSDL_VALIDATOR";
    protected final String _ERROR_NO_WSDL_VALIDATOR = "_ERROR_NO_WSDL_VALIDATOR";
    protected final String _ERROR_PROBLEM_EXT_VALIDATOR = "_ERROR_PROBLEM_EXT_VALIDATOR";
    protected final String _ERROR_DOCUMENT_LOCATION = "_ERROR_DOCUMENT_LOCATION";
    protected ValidatorRegistry ver;
    protected ResourceBundle resourcebundle;
    protected MessageGenerator messagegenerator;
    protected URIResolver uriResolver;

    public ValidationController(ResourceBundle rb, URIResolver uriResolver) {
        this.resourcebundle = rb;
        this.messagegenerator = new MessageGenerator(this.resourcebundle);
        this.uriResolver = uriResolver;
        this.ver = ValidatorRegistry.getInstance();
    }

    public IValidationReport validate(String uri, InputStream inputStream, WSDLValidationConfiguration configuration) {
        ByteArrayInputStream xmlValidateStream = null;
        ByteArrayInputStream wsdlValidateStream = null;
        if (inputStream != null) {
            String contents = this.createStringForInputStream(inputStream);
            xmlValidateStream = new ByteArrayInputStream(contents.getBytes());
            wsdlValidateStream = new ByteArrayInputStream(contents.getBytes());
        }
        ValidationInfoImpl valInfo = new ValidationInfoImpl(uri, this.messagegenerator);
        valInfo.setURIResolver(this.uriResolver);
        valInfo.setConfiguration(configuration);
        if (this.validateXML(valInfo, xmlValidateStream)) {
            String wsdlns;
            Document wsdldoc = this.getDocument(uri, wsdlValidateStream, valInfo);
            if (!valInfo.hasErrors() && (wsdlns = this.getWSDLNamespace(wsdldoc)) != null && this.validateWSDL(wsdldoc, valInfo, wsdlns)) {
                this.validateExtensionValidators(wsdldoc, valInfo, wsdlns);
            }
        }
        return valInfo;
    }

    protected boolean validateXML(ControllerValidationInfo valInfo, InputStream inputStream) {
        IXMLValidator xmlValidator = AbstractXMLConformanceFactory.getInstance().getXMLValidator();
        xmlValidator.setURIResolver(this.uriResolver);
        xmlValidator.setFile(valInfo.getFileURI());
        if (xmlValidator instanceof DefaultXMLValidator) {
            ((DefaultXMLValidator)xmlValidator).setInputStream(inputStream);
            XMLGrammarPool grammarPool = (XMLGrammarPool)valInfo.getAttribute("http://www.eclipse.org/webtools/wsdl/xmlcache");
            if (grammarPool != null) {
                ((DefaultXMLValidator)xmlValidator).setGrammarPool(grammarPool);
            }
        }
        xmlValidator.run();
        if (xmlValidator.hasErrors()) {
            List errors = xmlValidator.getErrors();
            for (IValidationMessage valMes : errors) {
                if (valMes instanceof ValidationMessageImpl && valInfo instanceof ValidationInfoImpl) {
                    String errorKey = ((ValidationMessageImpl)valMes).getErrorKey();
                    Object[] messageArgs = ((ValidationMessageImpl)valMes).getMessageArguments();
                    ((ValidationInfoImpl)valInfo).addError(valMes.getMessage(), valMes.getLine(), valMes.getColumn(), valMes.getURI(), errorKey, messageArgs);
                    continue;
                }
                valInfo.addError(valMes.getMessage(), valMes.getLine(), valMes.getColumn(), valMes.getURI());
            }
            return false;
        }
        return true;
    }

    protected boolean validateXML(ControllerValidationInfo valInfo) {
        return this.validateXML(valInfo, null);
    }

    protected boolean validateWSDL(Document wsdldoc, ControllerValidationInfo valInfo, String wsdlNamespace) {
        WSDLValidatorDelegate[] wsdlVals = this.ver.queryValidatorRegistry(wsdlNamespace, ValidatorRegistry.WSDL_VALIDATOR);
        if (wsdlVals != null) {
            int i = 0;
            while (i < wsdlVals.length) {
                WSDLValidatorDelegate wsdlvaldel = wsdlVals[i];
                IWSDLValidator wsdlVal = wsdlvaldel.getValidator();
                if (wsdlVal != null) {
                    try {
                        wsdlVal.validate(wsdldoc, valInfo);
                    }
                    catch (ValidateWSDLException validateWSDLException) {
                        valInfo.addError(this.messagegenerator.getString("_ERROR_PROBLEM_WSDL_VALIDATOR", wsdlNamespace), 1, 1, valInfo.getFileURI());
                    }
                } else {
                    valInfo.addError(this.messagegenerator.getString("_ERROR_NO_WSDL_VALIDATOR", wsdlNamespace), 1, 1, valInfo.getFileURI());
                }
                ++i;
            }
        } else {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_WSDL_VALIDATOR", wsdlNamespace), 1, 1, valInfo.getFileURI());
        }
        valInfo.completeWSDLValidation();
        return valInfo.isWSDLValid();
    }

    protected void validateExtensionValidators(Document wsdldoc, ControllerValidationInfo valInfo, String wsdlNamespace) {
        WSDLValidatorDelegate[] extVals = this.ver.queryValidatorRegistry(wsdlNamespace, ValidatorRegistry.EXT_VALIDATOR);
        if (extVals != null) {
            int numvals = extVals.length;
            int i = 0;
            while (i < numvals) {
                WSDLValidatorDelegate extvaldel = extVals[i];
                IWSDLValidator extval = extvaldel.getValidator();
                if (extval != null) {
                    try {
                        extval.validate(wsdldoc, valInfo);
                    }
                    catch (Throwable t) {
                        valInfo.addWarning(this.messagegenerator.getString("_ERROR_PROBLEM_EXT_VALIDATOR", extvaldel.getValidatorName(), wsdlNamespace), 1, 1, valInfo.getFileURI());
                        LoggerFactory.getInstance().getLogger().log(this.messagegenerator.getString("_ERROR_PROBLEM_EXT_VALIDATOR", extvaldel.getValidatorName(), wsdlNamespace), 0, t);
                    }
                }
                ++i;
            }
        }
    }

    public void setResourceBundle(ResourceBundle rb) {
        this.resourcebundle = rb;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourcebundle;
    }

    private Document getDocument(String uri, InputStream inputStream, ControllerValidationInfo valinfo) {
        try {
            StandardParserConfiguration configuration = new StandardParserConfiguration(){

                protected XMLErrorReporter createErrorReporter() {
                    return new XMLErrorReporter(){

                        public String reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                            boolean reportError = true;
                            if (key.equals("PrematureEOF")) {
                                reportError = false;
                            }
                            if (reportError) {
                                return super.reportError(domain, key, arguments, severity);
                            }
                            return "";
                        }
                    };
                }
            };
            InputSource inputSource = null;
            inputSource = inputStream != null ? new InputSource(inputStream) : new InputSource(uri);
            LineNumberDOMParser builder = new LineNumberDOMParser((XMLParserConfiguration)configuration);
            builder.parse(inputSource);
            Document doc = builder.getDocument();
            return doc;
        }
        catch (Throwable throwable) {
            valinfo.addError(this.messagegenerator.getString("_ERROR_DOCUMENT_LOCATION", uri), 0, 0, uri);
            return null;
        }
    }

    private String getWSDLNamespace(Document doc) {
        Element rootdoc;
        String wsdlns = null;
        if (doc != null && (rootdoc = doc.getDocumentElement()) != null) {
            wsdlns = rootdoc.getNamespaceURI();
        }
        return wsdlns;
    }

    private final String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception exception) {}
        return fileString.toString();
    }
}

