/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.confluence.internal.ConfluenceContentState;
import org.eclipse.mylyn.wikitext.confluence.internal.ConfluenceDocumentBuilder;
import org.eclipse.mylyn.wikitext.confluence.internal.block.CodeBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ColorBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ExtendedPreformattedBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ExtendedQuoteBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.HeadingBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.HorizontalRuleBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.QuoteBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.TableBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.TableOfContentsBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.block.TextBoxBlock;
import org.eclipse.mylyn.wikitext.confluence.internal.phrase.ColorPhraseModifier;
import org.eclipse.mylyn.wikitext.confluence.internal.phrase.ConfluenceWrappedPhraseModifier;
import org.eclipse.mylyn.wikitext.confluence.internal.phrase.EmphasisPhraseModifier;
import org.eclipse.mylyn.wikitext.confluence.internal.phrase.HyperlinkPhraseModifier;
import org.eclipse.mylyn.wikitext.confluence.internal.phrase.ImagePhraseModifier;
import org.eclipse.mylyn.wikitext.confluence.internal.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.wikitext.confluence.internal.phrase.SimpleWrappedPhraseModifier;
import org.eclipse.mylyn.wikitext.confluence.internal.token.AnchorReplacementToken;
import org.eclipse.mylyn.wikitext.confluence.internal.token.EscapedCharacterReplacementToken;
import org.eclipse.mylyn.wikitext.confluence.internal.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.confluence.internal.token.NumericEntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.parser.markup.token.PatternEntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.parser.markup.token.PatternLineBreakReplacementToken;

public class ConfluenceLanguage
extends AbstractMarkupLanguage {
    private final List<Block> nestedBlocks = new ArrayList<Block>();
    private boolean parseRelativeLinks = true;

    public ConfluenceLanguage() {
        this.setName("Confluence");
    }

    protected void clearLanguageSyntax() {
        super.clearLanguageSyntax();
        this.nestedBlocks.clear();
    }

    public List<Block> getNestedBlocks() {
        return this.nestedBlocks;
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        HeadingBlock headingBlock = new HeadingBlock();
        blocks.add(headingBlock);
        paragraphBreakingBlocks.add(headingBlock);
        this.nestedBlocks.add(headingBlock);
        ListBlock listBlock = new ListBlock();
        blocks.add(listBlock);
        paragraphBreakingBlocks.add(listBlock);
        this.nestedBlocks.add(listBlock);
        blocks.add(new QuoteBlock());
        TableBlock tableBlock = new TableBlock();
        blocks.add(tableBlock);
        paragraphBreakingBlocks.add(tableBlock);
        this.nestedBlocks.add(tableBlock);
        ExtendedQuoteBlock quoteBlock = new ExtendedQuoteBlock();
        blocks.add(quoteBlock);
        paragraphBreakingBlocks.add(quoteBlock);
        ExtendedPreformattedBlock noformatBlock = new ExtendedPreformattedBlock();
        blocks.add(noformatBlock);
        paragraphBreakingBlocks.add(noformatBlock);
        HorizontalRuleBlock horizontalRuleBlock = new HorizontalRuleBlock();
        blocks.add(horizontalRuleBlock);
        paragraphBreakingBlocks.add(horizontalRuleBlock);
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.PANEL, "panel"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.NOTE, "note"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.INFORMATION, "info"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.WARNING, "warning"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.TIP, "tip"));
        CodeBlock codeBlock = new CodeBlock();
        blocks.add(codeBlock);
        paragraphBreakingBlocks.add(codeBlock);
        blocks.add(new TableOfContentsBlock());
        ColorBlock colorBlock = new ColorBlock();
        blocks.add(colorBlock);
        paragraphBreakingBlocks.add(colorBlock);
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new HyperlinkPhraseModifier(this.parseRelativeLinks));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.STRONG, true));
        phraseModifierSyntax.add((PatternBasedElement)new EmphasisPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("??", DocumentBuilder.SpanType.CITATION, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("-", DocumentBuilder.SpanType.DELETED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("+", DocumentBuilder.SpanType.UNDERLINED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, false));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT, false));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("@", DocumentBuilder.SpanType.CODE, false));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleWrappedPhraseModifier("{{", "}}", DocumentBuilder.SpanType.MONOSPACE, false));
        phraseModifierSyntax.add((PatternBasedElement)new ConfluenceWrappedPhraseModifier("{quote}", DocumentBuilder.SpanType.QUOTE, true));
        phraseModifierSyntax.add((PatternBasedElement)new ColorPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new ImagePhraseModifier());
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("(\\\\\\\\ ?)"));
        tokenSyntax.add((PatternBasedElement)new EscapedCharacterReplacementToken());
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=(?:\\w\\s)|^)(---)(?=\\s\\w))", "#8212"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=(?:\\w\\s)|^)(--)(?=\\s\\w))", "#8211"));
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new AnchorReplacementToken());
        tokenSyntax.add((PatternBasedElement)new NumericEntityReferenceReplacementToken());
    }

    protected Block createParagraphBlock() {
        return new ParagraphBlock();
    }

    public DocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        return new ConfluenceDocumentBuilder(out);
    }

    public void setParseRelativeLinks(boolean parseRelativeLinks) {
        this.parseRelativeLinks = parseRelativeLinks;
    }

    public boolean isParseRelativeLinks() {
        return this.parseRelativeLinks;
    }

    public ConfluenceLanguage clone() {
        ConfluenceLanguage copy = (ConfluenceLanguage)super.clone();
        copy.parseRelativeLinks = this.parseRelativeLinks;
        return copy;
    }

    protected ContentState createState() {
        return new ConfluenceContentState();
    }
}

