/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.connector;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.pde.connector.Activator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class PDEProjectHelper {
    private static final String PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private static boolean isListeningForPluginModelChanges = false;
    private static final List<IProject> PROJECTS_FOR_UPDATE_CLASSPATH = new ArrayList<IProject>();
    private static final IPluginModelListener CLASSPATH_UPDATER = delta -> {
        List<IProject> list = PROJECTS_FOR_UPDATE_CLASSPATH;
        synchronized (list) {
            PROJECTS_FOR_UPDATE_CLASSPATH.removeIf(project -> {
                IPluginModelBase model = PluginRegistry.findModel((IProject)project);
                if (model != null) {
                    UpdateClasspathWorkspaceJob job = new UpdateClasspathWorkspaceJob((IProject)project, model);
                    job.schedule();
                    return true;
                }
                return false;
            });
        }
    };

    private PDEProjectHelper() {
    }

    public void configurePDEBundleProject(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(PDE_PLUGIN_NATURE)) {
            CoreUtility.addNatureToProject((IProject)project, (String)PDE_PLUGIN_NATURE, null);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(this.getOutputLocation(project, mavenProject, monitor), monitor);
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null) {
            PDEProjectHelper.setClasspath(project, model, monitor);
        } else {
            this.addProjectForUpdateClasspath(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProjectForUpdateClasspath(IProject project) {
        List<IProject> list = PROJECTS_FOR_UPDATE_CLASSPATH;
        synchronized (list) {
            PROJECTS_FOR_UPDATE_CLASSPATH.add(project);
            if (!isListeningForPluginModelChanges) {
                PDECore pdeCore = PDECore.getDefault();
                pdeCore.getModelManager().addPluginModelListener(CLASSPATH_UPDATER);
                isListeningForPluginModelChanges = true;
            }
        }
    }

    private IPath getOutputLocation(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        File outputDirectory = new File(mavenProject.getBuild().getOutputDirectory());
        outputDirectory.mkdirs();
        IPath relPath = MavenProjectUtils.getProjectRelativePath((IProject)project, (String)outputDirectory.toString());
        IFolder folder = project.getFolder(relPath);
        folder.refreshLocal(2, monitor);
        return folder.getFullPath();
    }

    public static void addPDENature(IProject project, IPath manifestPath, IProgressMonitor monitor) throws CoreException {
        AbstractProjectConfigurator.addNature((IProject)project, (String)PDE_PLUGIN_NATURE, (IProgressMonitor)monitor);
        IProjectDescription description = project.getDescription();
        Stream<ICommand> builders = Arrays.stream(description.getBuildSpec()).filter(b -> !b.getBuilderName().startsWith("org.eclipse.pde"));
        description.setBuildSpec((ICommand[])builders.toArray(ICommand[]::new));
        project.setDescription(description, monitor);
        PDEProjectHelper.setManifestLocaton(project, manifestPath, monitor);
    }

    protected static void setManifestLocaton(IProject project, IPath manifestPath, IProgressMonitor monitor) throws CoreException {
        IBundleProjectService projectService = Activator.getBundleProjectService().get();
        if (manifestPath != null && manifestPath.segmentCount() > 1) {
            IPath metainfPath = manifestPath.removeLastSegments(1);
            project.getFile(metainfPath).refreshLocal(2, monitor);
            projectService.setBundleRoot(project, metainfPath);
        } else {
            projectService.setBundleRoot(project, null);
        }
    }

    public static IFile getBundleManifest(IProject project) {
        IContainer metainf = PDEProject.getBundleRoot((IProject)project);
        metainf = metainf == null || metainf instanceof IProject ? project.getFolder("META-INF") : metainf.getFolder((IPath)new Path("META-INF"));
        return metainf.getFile((IPath)new Path("MANIFEST.MF"));
    }

    private static void setClasspath(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] entries = ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, null, (boolean)true, (boolean)true);
        JavaCore.create((IProject)project).setRawClasspath(entries, null);
        IFile manifest = PDEProjectHelper.getBundleManifest(project);
        if (manifest.isAccessible()) {
            manifest.touch(monitor);
        }
    }

    private static class UpdateClasspathWorkspaceJob
    extends WorkspaceJob {
        private final IProject project;
        private final IPluginModelBase model;

        public UpdateClasspathWorkspaceJob(IProject project, IPluginModelBase model) {
            super("Updating classpath");
            this.project = project;
            this.model = model;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            PDEProjectHelper.setClasspath(this.project, this.model, monitor);
            return Status.OK_STATUS;
        }
    }
}

