/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TreeIterable
implements Iterable<EObject> {
    protected final @Nullable Resource resource;
    protected final @Nullable EObject rootEObject;
    protected final boolean includeRoot;

    public TreeIterable(@NonNull EObject rootEObject, boolean includeRoot) {
        this.resource = null;
        this.rootEObject = rootEObject;
        this.includeRoot = includeRoot;
    }

    public TreeIterable(@NonNull Resource resource) {
        this.resource = resource;
        this.rootEObject = null;
        this.includeRoot = false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull java.util.Iterator<@NonNull EObject> iterator() {
        if (this.resource != null) {
            @NonNull @NonNull TreeIterator allContents = this.resource.getAllContents();
            return allContents;
        }
        assert (this.rootEObject != null);
        return new Iterator(this.rootEObject, this.includeRoot);
    }

    private static class Iterator
    implements java.util.Iterator<EObject> {
        protected @Nullable EObject firstEObject;
        protected final @NonNull TreeIterator<@NonNull EObject> tit;

        public Iterator(@NonNull EObject rootEObject, boolean includeRoot) {
            TreeIterator eAllContents;
            this.firstEObject = includeRoot ? rootEObject : null;
            this.tit = eAllContents = rootEObject.eAllContents();
        }

        @Override
        public boolean hasNext() {
            return this.firstEObject != null || this.tit.hasNext();
        }

        @Override
        public @NonNull EObject next() {
            EObject eObject;
            if (this.firstEObject != null) {
                eObject = this.firstEObject;
                this.firstEObject = null;
            } else {
                eObject = (EObject)this.tit.next();
            }
            return eObject;
        }
    }
}

